//---------------------------------------------------------------------------

#ifndef FiltersH
#define FiltersH


#include <math.h>
#include <values.h>
#include <mem.h>

#ifndef TWOPI
#define TWOPI 2*M_PI
#endif

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////    /////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------
class TFilter
{ protected:
  private:
        float *Z;  //  
        float *B;  // 
        int N;
        float F0;
  public:
        TFilter(float F1, float F2);
        ~TFilter();
        void filter(float * x, int n, float * y);
        float filter(float x);
        float getF0(void);
};
//------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
////////////       //////////////////
////////////////////////////////////////////////////////////////////////////////
class TIIRLPF
{
  private:
   long double A, B;
   long double * Y;
   int N;
  public:
        TIIRLPF(float Fs, int Nz);
        ~TIIRLPF();
        long double filter(long double x);
        float filter(float * x, int n);

};
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
///////////    2-  //////////////////////////
////////////////////////////////////////////////////////////////////////////////
class TIIRBPF2
{ private:
    long double A0, A1, A2;
    long double B1, B2;
    long double Y0, Y1, Y2;
    long double X0, X1, X2;
  public:
        long double f0, ph, dph, ddph;
        TIIRBPF2(float Fc, float BW);
        float filter(float x);
        float filter(float x[], int n, float y[]);
   
};
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
//////////// CIC -  4-    ////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
class TCIC4
{ private:
    double Y1[4];
    double Z1[4], Z2[4];

  public:
        TCIC4();
        double pre_decim(double x);
        double post_decim(double x);

};
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
#endif
