//---------------------------------------------------------------------------

#include <vcl.h>

#pragma hdrstop

#include "MyOpRx1.h"
#include "MyOpRx2.h"
#include "MyOpRx3.h"
#include "Sound.h"
#include "Filters.h"
#include "PSKReporter.h"
#include "WaveFile.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

#define SND_FD 12000  //12000
#define SND_LEN 12000 //12000
#define SND_FD2 48000
#define SND_LEN2 48000
#define CLIP_POROG 3.0  //       
#define DF 0.122 //0.122  //   []    0.7
#define DF2 0.122 //
#define NF 1230 // - 
#define K12 24      //  
#define KDECIM 1024 //1024 // 
#define N8192 4 //4    // -    8.192 
#define LEN_M_OP (239*N8192+1) //     >= 239*(-    8.192 ) +1
#define N_OPCALL 1000
#define CORRELATOR_SHIFT 230 // 230
#define CORRELATOR_LOOKUP 230 // 80
#define LEN_X_OP 1048576 //978944 //(239*8.192*SND_FD/K12)

TForm1 *Form1;
TSound *snd;
TWaveFile *wf;
TIIRBPF2 * BPF[NF+2];
//TIIRBPF2 * BPF2[NF+2];
//TIIRBPF2 * BPF3[NF+2];
TIIRLPF  * LPF[NF+2];
TFilter * filter1;
TIIRLPF * filter2;
bool AUDIO_RX_WORKED;
HANDLE hAudioRx;
bool processWav;
float x[SND_LEN+2],x1[SND_LEN+2];
float x2[SND_LEN2+2];
float U[NF+2];
float u0[NF+2];
double Uslow[NF+2];
double Uthr[NF+2];
float OP[NF+2][LEN_M_OP+N8192+N8192+2];
char OP2[NF+2][LEN_M_OP+N8192+N8192+2];   //  
float OP_DRIFT[LEN_M_OP+N8192+N8192+2]; //   
char OP2_DRIFT[LEN_M_OP+N8192+N8192+2];
//float x_op[LEN_X_OP+2];  //        100-200 
int pos_x_op; 
float Usred;
double F0;  //   
int cntClip;
int cntImage3;
unsigned int cntDecim;
double Fdial;
int OscillMode;
int OscillN;
AnsiString mycall;  // -  
AnsiString myqth;
AnsiString my_detected;
AnsiString CaptureFilename;
int CNT_OP; //     (    ,   239 )
bool DEEP_ALLOWED;
double max1max2;

struct
{ char callsign[7];
  float db;
  float db2;
  float db3;
  float correlation;
  float fade;
  int n;
  time_t t;
  int shift;
  int attempt;
  int cc;
  bool op;
}op_call[N_OPCALL+1];
int op_shift;

struct
{ AnsiString call;
  AnsiString qth;
  char pic[240];
  int v51[52];
  double km;
  int n_repeat;
  int nf;
  time_t t;
}callslist[N_OPCALL+1];
int nc;

int ignorelist[NF+2];
int freqlist[NF+2];
int blockedlist[NF+2];
int nmax[NF+2];
int maxNmax; //       
int user_maxNmax;
int minpkspace; //   
int user_minpkspace;
AnsiString capturePath;
double ph, dph;
double ph2, dph2;
double op_db_shift;
double op_threshold;
double opds_threshold;
int correlator_threshold;
int correlator_threshold239;
int T_CALL_BLOCK;
bool reverse_output;
bool decoder_zero_test;
AnsiString myheader;
REPORTER_STATISTICS Rep;
char mutexname[50];
AnsiString commandExecStr;
bool commandExec;
bool decoderDrift, decoderTshift;
double umax_threshold;
int waterfalContrast, oscillogrammMode;
int cnt_qrss_mode;
time_t t_label_old;
int YYY;
/////////////////////////////////////////////////////////////////////////////

float sign(float x)
{
   if(x>0) return 1.0;
   if(x<0) return -1.0;
   return 0;
}
/////////////////////////////////////////////////////////////////////////////
#define Ntap 255
float fir1500_12k(float NewSample) {

    float FIRCoef[Ntap] = {
         0.00003493532234585989,         0.00000445874326273974,        -0.00008693372527811520,
        -0.00016408664364959074,        -0.00014504316730451367,        -0.00001522713619878570,
         0.00015070478878994109,         0.00024004039948621306,         0.00018747805041408026,
         0.00002688080376511868,        -0.00013342022817003628,        -0.00019362204203066978,
        -0.00013742620952297201,        -0.00003728673729504627,         0.00001546947086768827,
        -0.00000319565096699141,        -0.00002501324131301661,         0.00004423050844307447,
         0.00021650227546684373,         0.00036875915285043833,         0.00031223252344543052,
        -0.00004564767585957313,        -0.00056739078056505809,        -0.00090845306817914813,
        -0.00072668625244471535,         0.00003986452814723142,         0.00103170007147600500,
         0.00161186248083405050,         0.00125882717710060300,        -0.00002582593123456243,
        -0.00159204798913470240,        -0.00245063818979799220,        -0.00188560556274748040,
         0.00000328633382389583,         0.00221827037326683980,         0.00337731051392276950,
         0.00256971833802525270,         0.00002705958563467733,        -0.00286726540929323980,
        -0.00432526498938786380,        -0.00325976630159510340,        -0.00006352727082625939,
         0.00348368922494956360,         0.00521004202479046640,         0.00389143477189460210,
         0.00010348883444677097,        -0.00400157224767796250,        -0.00593205337922754480,
        -0.00438975600052215250,        -0.00014352306036655992,         0.00434687448974865800,
         0.00638072367567973050,         0.00467244278916547840,         0.00017966629373047951,
        -0.00444093874499896980,        -0.00643996877066087360,        -0.00465420544746135860,
        -0.00020775070455016962,         0.00420473650022611630,         0.00599481992851304360,
         0.00425188325544467290,         0.00022380561250486604,        -0.00356373551211909080,
        -0.00493889964965747550,        -0.00339014247660370410,        -0.00022448821611755851,
         0.00245315450760593120,         0.00318235890322731430,         0.00200742189285585710,
         0.00020750354373284889,        -0.00082331372433038191,        -0.00065980397623339342,
        -0.00006174994099276347,        -0.00017197070296022155,        -0.00135525520560799270,
        -0.00266231828135796070,        -0.00246397949259246010,         0.00011869401489281787,
         0.00408730543315062070,         0.00677943855622287210,         0.00555769816678761820,
        -0.00005030307537678028,        -0.00734935061747584060,        -0.01164424435394606000,
        -0.00917523222941671320,        -0.00002876587943620367,         0.01108747711751613100,
         0.01716423629947460400,         0.01323911600798286500,         0.00011246527720741044,
        -0.01521680578123187400,        -0.02320189576468641500,        -0.01763944686592560200,
        -0.00019351670759646902,         0.01962284481480807600,         0.02957777823682489600,
         0.02223697976914125500,         0.00026397665905148116,        -0.02416487767613856300,
        -0.03607669258846098900,        -0.02686854004068264100,        -0.00031597928940035663,
         0.02868141213518127600,         0.04245694575415054400,         0.03135469498098754400,
         0.00034263751201246896,        -0.03299759006749235900,        -0.04846244164994586300,
        -0.03550948185995369400,        -0.00033906826996418532,         0.03693434670463457300,
         0.05383726516203417300,         0.03915188188825953500,         0.00030348983705619605,
        -0.04031908829429416800,        -0.05834242144575077500,        -0.04211885488276474700,
        -0.00023839846628627526,         0.04299797474959372200,         0.06177532476401883400,
         0.04428095372549750700,         0.00015189266304870997,        -0.04485373468085013900,
        -0.06400378637730190500,        -0.04558157029620615200,        -0.00008177415734322149,
         0.04583884667981191100,         0.06524562733112393400,         0.04583884667981191100,
        -0.00008177415734322149,        -0.04558157029620615200,        -0.06400378637730190500,
        -0.04485373468085013900,         0.00015189266304870997,         0.04428095372549750700,
         0.06177532476401883400,         0.04299797474959372200,        -0.00023839846628627526,
        -0.04211885488276474700,        -0.05834242144575077500,        -0.04031908829429416800,
         0.00030348983705619605,         0.03915188188825953500,         0.05383726516203417300,
         0.03693434670463457300,        -0.00033906826996418532,        -0.03550948185995369400,
        -0.04846244164994586300,        -0.03299759006749235900,         0.00034263751201246896,
         0.03135469498098754400,         0.04245694575415054400,         0.02868141213518127600,
        -0.00031597928940035663,        -0.02686854004068264100,        -0.03607669258846098900,
        -0.02416487767613856300,         0.00026397665905148116,         0.02223697976914125500,
         0.02957777823682489600,         0.01962284481480807600,        -0.00019351670759646902,
        -0.01763944686592560200,        -0.02320189576468641500,        -0.01521680578123187400,
         0.00011246527720741044,         0.01323911600798286500,         0.01716423629947460400,
         0.01108747711751613100,        -0.00002876587943620367,        -0.00917523222941671320,
        -0.01164424435394606000,        -0.00734935061747584060,        -0.00005030307537678028,
         0.00555769816678761820,         0.00677943855622287210,         0.00408730543315062070,
         0.00011869401489281787,        -0.00246397949259246010,        -0.00266231828135796070,
        -0.00135525520560799270,        -0.00017197070296022155,        -0.00006174994099276347,
        -0.00065980397623339342,        -0.00082331372433038191,         0.00020750354373284889,
         0.00200742189285585710,         0.00318235890322731430,         0.00245315450760593120,
        -0.00022448821611755851,        -0.00339014247660370410,        -0.00493889964965747550,
        -0.00356373551211909080,         0.00022380561250486604,         0.00425188325544467290,
         0.00599481992851304360,         0.00420473650022611630,        -0.00020775070455016962,
        -0.00465420544746135860,        -0.00643996877066087360,        -0.00444093874499896980,
         0.00017966629373047951,         0.00467244278916547840,         0.00638072367567973050,
         0.00434687448974865800,        -0.00014352306036655992,        -0.00438975600052215250,
        -0.00593205337922754480,        -0.00400157224767796250,         0.00010348883444677097,
         0.00389143477189460210,         0.00521004202479046640,         0.00348368922494956360,
        -0.00006352727082625939,        -0.00325976630159510340,        -0.00432526498938786380,
        -0.00286726540929323980,         0.00002705958563467733,         0.00256971833802525270,
         0.00337731051392276950,         0.00221827037326683980,         0.00000328633382389583,
        -0.00188560556274748040,        -0.00245063818979799220,        -0.00159204798913470240,
        -0.00002582593123456243,         0.00125882717710060300,         0.00161186248083405050,
         0.00103170007147600500,         0.00003986452814723142,        -0.00072668625244471535,
        -0.00090845306817914813,        -0.00056739078056505809,        -0.00004564767585957313,
         0.00031223252344543052,         0.00036875915285043833,         0.00021650227546684373,
         0.00004423050844307447,        -0.00002501324131301661,        -0.00000319565096699141,
         0.00001546947086768827,        -0.00003728673729504627,        -0.00013742620952297201,
        -0.00019362204203066978,        -0.00013342022817003628,         0.00002688080376511868,
         0.00018747805041408026,         0.00024004039948621306,         0.00015070478878994109,
        -0.00001522713619878570,        -0.00014504316730451367,        -0.00016408664364959074,
        -0.00008693372527811520,         0.00000445874326273974,         0.00003493532234585989
    };

    static float x[Ntap]; //input samples
    float y=0;            //output sample
    int n;
    static int pos;
    x[pos] = NewSample;
    for(n=pos; n<Ntap; n++) y += FIRCoef[n-pos] * x[n];
    for(n=0; n<pos; n++) y += FIRCoef[Ntap-pos+n] * x[n];
    pos--; if(pos<0)pos=Ntap-1;
    return y;
}
/////////////////////////////////////////////////////////////////////////////
float fir2500_12k(float NewSample) {
    float FIRCoef[Ntap] = {
        -0.00263479693569705330,
        -0.00024811917143617183,
         0.00708608365058616300,
         0.00513112879617643420,
        -0.00741484864407211590,
        -0.01112361362098572600,
         0.00267247361467381690,
         0.01397395753981301200,
         0.00464190319092271880,
        -0.01139740070561157600,
        -0.01004214360080372800,
         0.00474539873828046500,
         0.00986653923433816750,
         0.00140424728304159360,
        -0.00395704295513454700,
        -0.00176454453897405530,
        -0.00338146398889531230,
        -0.00616561680303442330,
         0.00501214503557761810,
         0.01947250582574088000,
         0.00521645155756061270,
        -0.02976295488992107600,
        -0.02813068479978795400,
         0.02631131218010673500,
         0.05664487840372345300,
        -0.00150129627400899830,
        -0.07676196482464192600,
        -0.04373544824969018800,
         0.07255556876616382800,
         0.09727615360969493800,
        -0.03362400415691102500,
        -0.13797322305499882000,
        -0.03802214491229805700,
         0.14275455125403388000,
         0.12504594521206122000,
        -0.09648489710341522100,
        -0.19809579042126368000,
         0.00070752219371107391,
         0.22519962511695238000,
         0.12285664653015517000,
        -0.18435179832855089000,
        -0.23660976873550318000,
         0.07448208939594258600,
         0.29878190126489290000,
         0.08012017984348385200,
        -0.27889799867617565000,
        -0.23484936513744634000,
         0.17120290188458612000,
         0.33866022412141056000,
        -0.00025091094671620963,
        -0.35235857285819300000,
        -0.18465965623583014000,
         0.26446542306782000000,
         0.32532620982521676000,
        -0.09796785227435952900,
        -0.37552014141195311000,
        -0.09574617097390508700,
         0.31898979187914539000,
         0.25458145248184982000,
        -0.17701020919022367000,
        -0.32892181634808182000,
         0.00146188533046991770,
         0.30125797619102224000,
         0.14493337292964001000,
        -0.19379422148729220000,
        -0.21401840661911731000,
         0.05981177240927609100,
         0.19292589588970482000,
         0.03892818526626874700,
        -0.11074071717623361000,
        -0.06020252027895740100,
         0.02678955191848208000,
         0.00292034175036632450,
        -0.00377070480577186170,
         0.08814096012897396100,
         0.07598727240433145200,
        -0.13879389840607712000,
        -0.22644953584503802000,
         0.07866604250486437800,
         0.38462244946775759000,
         0.12126323445945189000,
        -0.44924962767351440000,
        -0.42305014273922675000,
         0.33039949122743506000,
         0.72170013218257523000,
         0.00439590733604490040,
        -0.87540817986004205000,
        -0.49927352155573151000,
         0.75880079317805083000,
         1.01055363497277840000,
        -0.32098446164062522000,
        -1.34433321418879910000,
        -0.37477288416109750000,
         1.32258228257212670000,
         1.14917550251338780000,
        -0.85630295019020464000,
        -1.75023023027568540000,
        -0.00180820196409263050,
         1.93249324705190180000,
         1.04885491621705150000,
        -1.54769628732086370000,
        -1.97745163888400180000,
         0.61448080009477213000,
         2.46654985903622400000,
         0.66140556638706738000,
        -2.29030285797802690000,
        -1.93026738094901300000,
         1.40804467949221300000,
         2.79722249016299070000,
        -0.00124811184945402090,
        -2.94792832523533430000,
        -1.56112281036959490000,
         2.26023404801310200000,
         2.82378246369027640000,
        -0.86204975245745707000,
        -3.38396312863207040000,
        -0.88867212875975099000,
         3.02379978904596890000,
         2.50071956822837290000,
        -1.79142031205207550000,
        -3.49569108032223410000,
         0.00071383106516162062,
         3.55748302345292760000,
         1.85400541040564650000,
        -2.63654843577638240000,
        -3.24563882867114910000,
         0.96856492179877174000,
         3.77843363303998680000,
         0.96856492179877174000,
        -3.24563882867114910000,
        -2.63654843577638240000,
         1.85400541040564650000,
         3.55748302345292760000,
         0.00071383106516162062,
        -3.49569108032223410000,
        -1.79142031205207550000,
         2.50071956822837290000,
         3.02379978904596890000,
        -0.88867212875975099000,
        -3.38396312863207040000,
        -0.86204975245745707000,
         2.82378246369027640000,
         2.26023404801310200000,
        -1.56112281036959490000,
        -2.94792832523533430000,
        -0.00124811184945402090,
         2.79722249016299070000,
         1.40804467949221300000,
        -1.93026738094901300000,
        -2.29030285797802690000,
         0.66140556638706738000,
         2.46654985903622400000,
         0.61448080009477213000,
        -1.97745163888400180000,
        -1.54769628732086370000,
         1.04885491621705150000,
         1.93249324705190180000,
        -0.00180820196409263050,
        -1.75023023027568540000,
        -0.85630295019020464000,
         1.14917550251338780000,
         1.32258228257212670000,
        -0.37477288416109750000,
        -1.34433321418879910000,
        -0.32098446164062522000,
         1.01055363497277840000,
         0.75880079317805083000,
        -0.49927352155573151000,
        -0.87540817986004205000,
         0.00439590733604490040,
         0.72170013218257523000,
         0.33039949122743506000,
        -0.42305014273922675000,
        -0.44924962767351440000,
         0.12126323445945189000,
         0.38462244946775759000,
         0.07866604250486437800,
        -0.22644953584503802000,
        -0.13879389840607712000,
         0.07598727240433145200,
         0.08814096012897396100,
        -0.00377070480577186170,
         0.00292034175036632450,
         0.02678955191848208000,
        -0.06020252027895740100,
        -0.11074071717623361000,
         0.03892818526626874700,
         0.19292589588970482000,
         0.05981177240927609100,
        -0.21401840661911731000,
        -0.19379422148729220000,
         0.14493337292964001000,
         0.30125797619102224000,
         0.00146188533046991770,
        -0.32892181634808182000,
        -0.17701020919022367000,
         0.25458145248184982000,
         0.31898979187914539000,
        -0.09574617097390508700,
        -0.37552014141195311000,
        -0.09796785227435952900,
         0.32532620982521676000,
         0.26446542306782000000,
        -0.18465965623583014000,
        -0.35235857285819300000,
        -0.00025091094671620963,
         0.33866022412141056000,
         0.17120290188458612000,
        -0.23484936513744634000,
        -0.27889799867617565000,
         0.08012017984348385200,
         0.29878190126489290000,
         0.07448208939594258600,
        -0.23660976873550318000,
        -0.18435179832855089000,
         0.12285664653015517000,
         0.22519962511695238000,
         0.00070752219371107391,
        -0.19809579042126368000,
        -0.09648489710341522100,
         0.12504594521206122000,
         0.14275455125403388000,
        -0.03802214491229805700,
        -0.13797322305499882000,
        -0.03362400415691102500,
         0.09727615360969493800,
         0.07255556876616382800,
        -0.04373544824969018800,
        -0.07676196482464192600,
        -0.00150129627400899830,
         0.05664487840372345300,
         0.02631131218010673500,
        -0.02813068479978795400,
        -0.02976295488992107600,
         0.00521645155756061270,
         0.01947250582574088000,
         0.00501214503557761810,
        -0.00616561680303442330,
        -0.00338146398889531230,
        -0.00176454453897405530,
        -0.00395704295513454700,
         0.00140424728304159360,
         0.00986653923433816750,
         0.00474539873828046500,
        -0.01004214360080372800,
        -0.01139740070561157600,
         0.00464190319092271880,
         0.01397395753981301200,
         0.00267247361467381690,
        -0.01112361362098572600,
        -0.00741484864407211590,
         0.00513112879617643420,
         0.00708608365058616300,
        -0.00024811917143617183,
        -0.00263479693569705330
    };


    static float x[Ntap]; //input samples
    float y=0;            //output sample
    int n;
    static int pos;
    x[pos] = NewSample;
    for(n=pos; n<Ntap; n++) y += FIRCoef[n-pos] * x[n];
    for(n=0; n<pos; n++) y += FIRCoef[Ntap-pos+n] * x[n];
    pos--; if(pos<0)pos=Ntap-1;
    return y;
}
/////////////////////////////////////////////////////////////////////////////
float fir2000_12k(float NewSample) {

    float FIRCoef[Ntap] = {
        0.00050483740782751173,
        0.00194770560178096460,
        0.00141473539612683870,
       -0.00172921562038303280,
       -0.00415038535613145450,
       -0.00240095801102252960,
        0.00238869422778506750,
        0.00519081930641930760,
        0.00278726510694142200,
       -0.00232636894981456390,
       -0.00475182749034966730,
       -0.00241230908821602660,
        0.00140468600830909330,
        0.00255496144257122280,
        0.00113443319015337030,
        0.00048569453573624600,
        0.00162080171689187320,
        0.00115846945352840570,
       -0.00341712705112510790,
       -0.00792058939094944170,
       -0.00453923933136250040,
        0.00741665605235026630,
        0.01639613468242339500,
        0.00903226155904559080,
       -0.01245852558960694300,
       -0.02699003445477189300,
       -0.01460519877466167000,
        0.01845792548759668900,
        0.03952256524275423600,
        0.02116204102714511900,
       -0.02526637723009608400,
       -0.05368184617571647400,
       -0.02853786015947633700,
        0.03266914128416287300,
        0.06901809660387678300,
        0.03649564040618371400,
       -0.04038498378171477600,
       -0.08494266285492349500,
       -0.04472553236717083400,
        0.04806857299239980500,
        0.10073238215902916000,
        0.05284684268676902900,
       -0.05531568601368528500,
       -0.11553971185699115000,
       -0.06041302420236129700,
        0.06167129664564506600,
        0.12840887923880914000,
        0.06691986772334848600,
       -0.06664049152816128900,
       -0.13829810369539983000,
       -0.07181701319708892800,
        0.06970202997570222600,
        0.14410771167969155000,
        0.07452279119512367200,
       -0.07032423134638053600,
       -0.14471371120456381000,
       -0.07444227273482148500,
        0.06798275047362299700,
        0.13900612294926404000,
        0.07098824568133821300,
       -0.06217969449718792300,
       -0.12593108806837056000,
       -0.06360465147067583000,
        0.05246344996837797700,
        0.10453549907640905000,
        0.05179181255281691700,
       -0.03844853200071465800,
       -0.07401264232703480600,
       -0.03513256904864708200,
        0.01983473961627503800,
        0.03374711316191671100,
        0.01331823746320311500,
        0.00357509728237287790,
        0.01664291602970396600,
        0.01382687613516497100,
       -0.03185946683781124000,
       -0.07726811153916603200,
       -0.04632380926154091400,
        0.06496525988731083300,
        0.14793715010042988000,
        0.08402158598253962900,
       -0.10269816802615823000,
       -0.22813465665307076000,
       -0.12658560336806676000,
        0.14471690234041937000,
        0.31700974422055489000,
        0.17349305487668076000,
       -0.19053166618548145000,
       -0.41337669751055023000,
       -0.22403642312878644000,
        0.23950724052944847000,
        0.51572892449771135000,
        0.27733569294997173000,
       -0.29087096389267236000,
       -0.62226676715728579000,
       -0.33235944696582548000,
        0.34372580698598887000,
        0.73093913255467524000,
        0.38795443926919243000,
       -0.39706864884582344000,
       -0.83949821223266430000,
       -0.44288264303945907000,
        0.44981375149352332000,
        0.94556585408876082000,
        0.49586419781757124000,
       -0.50082130666464086000,
       -1.04670951915818480000,
       -0.54562422309468950000,
        0.54893081933215149000,
        1.14052533827409340000,
        0.59094122893755108000,
       -0.59299910506895603000,
       -1.22472588335726500000,
       -0.63069502931065025000,
        0.63194318316121101000,
        1.29723172808753380000,
        0.66391309891799832000,
       -0.66479080370018184000,
       -1.35627178008376070000,
       -0.68981777667301825000,
        0.69075309038700039000,
        1.40052299815298030000,
        0.70789031891088361000,
       -0.70941140825376547000,
       -1.42948275940761850000,
       -0.71805079282964690000,
        0.72245187100911701000,
        1.44703808277952570000,
        0.72245187100911701000,
       -0.71805079282964690000,
       -1.42948275940761850000,
       -0.70941140825376547000,
        0.70789031891088361000,
        1.40052299815298030000,
        0.69075309038700039000,
       -0.68981777667301825000,
       -1.35627178008376070000,
       -0.66479080370018184000,
        0.66391309891799832000,
        1.29723172808753380000,
        0.63194318316121101000,
       -0.63069502931065025000,
       -1.22472588335726500000,
       -0.59299910506895603000,
        0.59094122893755108000,
        1.14052533827409340000,
        0.54893081933215149000,
       -0.54562422309468950000,
       -1.04670951915818480000,
       -0.50082130666464086000,
        0.49586419781757124000,
        0.94556585408876082000,
        0.44981375149352332000,
       -0.44288264303945907000,
       -0.83949821223266430000,
       -0.39706864884582344000,
        0.38795443926919243000,
        0.73093913255467524000,
        0.34372580698598887000,
       -0.33235944696582548000,
       -0.62226676715728579000,
       -0.29087096389267236000,
        0.27733569294997173000,
        0.51572892449771135000,
        0.23950724052944847000,
       -0.22403642312878644000,
       -0.41337669751055023000,
       -0.19053166618548145000,
        0.17349305487668076000,
        0.31700974422055489000,
        0.14471690234041937000,
       -0.12658560336806676000,
       -0.22813465665307076000,
       -0.10269816802615823000,
        0.08402158598253962900,
        0.14793715010042988000,
        0.06496525988731083300,
       -0.04632380926154091400,
       -0.07726811153916603200,
       -0.03185946683781124000,
        0.01382687613516497100,
        0.01664291602970396600,
        0.00357509728237287790,
        0.01331823746320311500,
        0.03374711316191671100,
        0.01983473961627503800,
       -0.03513256904864708200,
       -0.07401264232703480600,
       -0.03844853200071465800,
        0.05179181255281691700,
        0.10453549907640905000,
        0.05246344996837797700,
       -0.06360465147067583000,
       -0.12593108806837056000,
       -0.06217969449718792300,
        0.07098824568133821300,
        0.13900612294926404000,
        0.06798275047362299700,
       -0.07444227273482148500,
       -0.14471371120456381000,
       -0.07032423134638053600,
        0.07452279119512367200,
        0.14410771167969155000,
        0.06970202997570222600,
       -0.07181701319708892800,
       -0.13829810369539983000,
       -0.06664049152816128900,
        0.06691986772334848600,
        0.12840887923880914000,
        0.06167129664564506600,
       -0.06041302420236129700,
       -0.11553971185699115000,
       -0.05531568601368528500,
        0.05284684268676902900,
        0.10073238215902916000,
        0.04806857299239980500,
       -0.04472553236717083400,
       -0.08494266285492349500,
       -0.04038498378171477600,
        0.03649564040618371400,
        0.06901809660387678300,
        0.03266914128416287300,
       -0.02853786015947633700,
       -0.05368184617571647400,
       -0.02526637723009608400,
        0.02116204102714511900,
        0.03952256524275423600,
        0.01845792548759668900,
       -0.01460519877466167000,
       -0.02699003445477189300,
       -0.01245852558960694300,
        0.00903226155904559080,
        0.01639613468242339500,
        0.00741665605235026630,
       -0.00453923933136250040,
       -0.00792058939094944170,
       -0.00341712705112510790,
        0.00115846945352840570,
        0.00162080171689187320,
        0.00048569453573624600,
        0.00113443319015337030,
        0.00255496144257122280,
        0.00140468600830909330,
       -0.00241230908821602660,
       -0.00475182749034966730,
       -0.00232636894981456390,
        0.00278726510694142200,
        0.00519081930641930760,
        0.00238869422778506750,
       -0.00240095801102252960,
       -0.00415038535613145450,
       -0.00172921562038303280,
        0.00141473539612683870,
        0.00194770560178096460,
        0.00050483740782751173
    };

    static float x[Ntap]; //input samples
    float y=0;            //output sample
    int n;
    static int pos;
    x[pos] = NewSample;
    for(n=pos; n<Ntap; n++) y += FIRCoef[n-pos] * x[n];
    for(n=0; n<pos; n++) y += FIRCoef[Ntap-pos+n] * x[n];
    pos--; if(pos<0)pos=Ntap-1;
    return y;
}
/////////////////////////////////////////////////////////////////////////////
//#define Ntap2 63
#define Ntap2 255
float fir200(float NewSample) {
   /*
    float FIRCoef[Ntap2] = {
        0.00212904232132587160,
        0.00164292131282833170,
        0.00097750042698207151,
        0.00013439324165251466,
       -0.00087494608328763778,
       -0.00202783176447204850,
       -0.00328922900901721350,
       -0.00461101234768543370,
       -0.00593170269379743230,
       -0.00717678272536650520,
       -0.00825968181465540010,
       -0.00908350801178949350,
       -0.00954358513534055500,
       -0.00953082780305376970,
       -0.00893595613910065300,
       -0.00765451533735061510,
       -0.00559262336598208200,
       -0.00267332376639588560,
        0.00115663017965217600,
        0.00591978733487696310,
        0.01160109145104467300,
        0.01814139904470035700,
        0.02543183164246629000,
        0.03330944043808187200,
        0.04155474636921278900,
        0.04989181832736343900,
        0.05799171291210029200,
        0.06548031992715568100,
        0.07195217596323517900,
        0.07699262358112944600,
        0.08021490403386019600,
        0.08132637497925294900,
        0.08021490403386019600,
        0.07699262358112944600,
        0.07195217596323517900,
        0.06548031992715568100,
        0.05799171291210029200,
        0.04989181832736343900,
        0.04155474636921278900,
        0.03330944043808187200,
        0.02543183164246629000,
        0.01814139904470035700,
        0.01160109145104467300,
        0.00591978733487696310,
        0.00115663017965217600,
       -0.00267332376639588560,
       -0.00559262336598208200,
       -0.00765451533735061510,
       -0.00893595613910065300,
       -0.00953082780305376970,
       -0.00954358513534055500,
       -0.00908350801178949350,
       -0.00825968181465540010,
       -0.00717678272536650520,
       -0.00593170269379743230,
       -0.00461101234768543370,
       -0.00328922900901721350,
       -0.00202783176447204850,
       -0.00087494608328763778,
        0.00013439324165251466,
        0.00097750042698207151,
        0.00164292131282833170,
        0.00212904232132587160
    };
    */
     float FIRCoef[Ntap2] = {
        0.00002539168200764659,
        0.00005341579448396770,
        0.00008333385088421897,
        0.00011431861503039200,
        0.00014546952689584310,
        0.00017583012888083027,
        0.00020440721995288101,
        0.00023019142723817011,
        0.00025217885120873683,
        0.00026939341211198482,
        0.00028090950238253084,
        0.00028587453287296356,
        0.00028353095036881624,
        0.00027323730024736583,
        0.00025448791158547878,
        0.00022693079266485565,
        0.00019038334261406483,
        0.00014484550986655254,
        0.00009051005992020156,
        0.00002776965331457324,
        -0.00004277952070817465,
        -0.00012033775915993316,
        -0.00020390565800263561,
        -0.00029229181222750305,
        -0.00038412443004771024,
        -0.00047786682247177924,
        -0.00057183666247525168,
        -0.00066422884034799789,
        -0.00075314167467865456,
        -0.00083660617282604172,
        -0.00091261797185143234,
        -0.00097917153167579392,
        -0.00103429609788266230,
        -0.00107609290303097120,
        -0.00110277303360136410,
        -0.00111269535562794800,
        -0.00110440386649017310,
        -0.00107666382392391160,
        -0.00102849599668884320,
        -0.00095920838485042987,
        -0.00086842477172680195,
        -0.00075610949422863310,
        -0.00062258785367706022,
        -0.00046856163499038237,
        -0.00029511925802426275,
        -0.00010374015037958997,
        0.00010370699461923646,
        0.00032497232856818972,
        0.00055743949152697034,
        0.00079814685726223484,
        0.00104381534891129250,
        0.00129088269043039680,
        0.00153554385410931180,
        0.00177379735913627490,
        0.00200149697236787950,
        0.00221440826171599320,
        0.00240826935657920820,
        0.00257885518020129150,
        0.00272204433728672360,
        0.00283388776821619960,
        0.00291067822019942800,
        0.00294901953698559990,
        0.00294589473348896800,
        0.00289873180087087250,
        0.00280546618203000820,
        0.00266459886768640340,
        0.00247524908963936810,
        0.00223720063046434650,
        0.00195094082773251810,
        0.00161769142539892190,
        0.00123943051466527340,
        0.00081890491045072628,
        0.00035963242646059348,
        -0.00013410635967446951,
        -0.00065728712124621933,
        -0.00120417170068732220,
        -0.00176834890170870350,
        -0.00234278596903834130,
        -0.00291989041083136640,
        -0.00349158166083241800,
        -0.00404937192241673540,
        -0.00458445538717009230,
        -0.00508780487907517860,
        -0.00555027484403815970,
        -0.00596270948563186460,
        -0.00631605474367605800,
        -0.00660147272454502700,
        -0.00681045712260368310,
        -0.00693494812238185530,
        -0.00696744524220570520,
        -0.00690111657289053850,
        -0.00672990288031396440,
        -0.00644861507846169760,
        -0.00605302363972582810,
        -0.00553993859132982570,
        -0.00490727884991109910,
        -0.00415412976928882830,
        -0.00328078791770607460,
        -0.00228879225849116250,
        -0.00118094107991235450,
        0.00003870579648128231,
        0.00136483980728775750,
        0.00279093151829321820,
        0.00430927345381563240,
        0.00591103756251045490,
        0.00758634680148562950,
        0.00932436013225523140,
        0.01111337004579345000,
        0.01294091157418743100,
        0.01479388160822105200,
        0.01665866722986832800,
        0.01852128169429262400,
        0.02036750666916900900,
        0.02218303937795856500,
        0.02395364342794409400,
        0.02566530238571457900,
        0.02730437568941269900,
        0.02885775744779720000,
        0.03031304046081615200,
        0.03165869125695334300,
        0.03288424907554717000,
        0.03398057761628142000,
        0.03494023742661829500,
        0.03575815553394558900,
        0.03643312736640232100,
        0.03697219656398535000,
        0.03740955523847606900,
        0.03801519184868090700,
        0.03740955523847606900,
        0.03697219656398535000,
        0.03643312736640232100,
        0.03575815553394558900,
        0.03494023742661829500,
        0.03398057761628142000,
        0.03288424907554717000,
        0.03165869125695334300,
        0.03031304046081615200,
        0.02885775744779720000,
        0.02730437568941269900,
        0.02566530238571457900,
        0.02395364342794409400,
        0.02218303937795856500,
        0.02036750666916900900,
        0.01852128169429262400,
        0.01665866722986832800,
        0.01479388160822105200,
        0.01294091157418743100,
        0.01111337004579345000,
        0.00932436013225523140,
        0.00758634680148562950,
        0.00591103756251045490,
        0.00430927345381563240,
        0.00279093151829321820,
        0.00136483980728775750,
        0.00003870579648128231,
        -0.00118094107991235450,
        -0.00228879225849116250,
        -0.00328078791770607460,
        -0.00415412976928882830,
        -0.00490727884991109910,
        -0.00553993859132982570,
        -0.00605302363972582810,
        -0.00644861507846169760,
        -0.00672990288031396440,
        -0.00690111657289053850,
        -0.00696744524220570520,
        -0.00693494812238185530,
        -0.00681045712260368310,
        -0.00660147272454502700,
        -0.00631605474367605800,
        -0.00596270948563186460,
        -0.00555027484403815970,
        -0.00508780487907517860,
        -0.00458445538717009230,
        -0.00404937192241673540,
        -0.00349158166083241800,
        -0.00291989041083136640,
        -0.00234278596903834130,
        -0.00176834890170870350,
        -0.00120417170068732220,
        -0.00065728712124621933,
        -0.00013410635967446951,
        0.00035963242646059348,
        0.00081890491045072628,
        0.00123943051466527340,
        0.00161769142539892190,
        0.00195094082773251810,
        0.00223720063046434650,
        0.00247524908963936810,
        0.00266459886768640340,
        0.00280546618203000820,
        0.00289873180087087250,
        0.00294589473348896800,
        0.00294901953698559990,
        0.00291067822019942800,
        0.00283388776821619960,
        0.00272204433728672360,
        0.00257885518020129150,
        0.00240826935657920820,
        0.00221440826171599320,
        0.00200149697236787950,
        0.00177379735913627490,
        0.00153554385410931180,
        0.00129088269043039680,
        0.00104381534891129250,
        0.00079814685726223484,
        0.00055743949152697034,
        0.00032497232856818972,
        0.00010370699461923646,
        -0.00010374015037958997,
        -0.00029511925802426275,
        -0.00046856163499038237,
        -0.00062258785367706022,
        -0.00075610949422863310,
        -0.00086842477172680195,
        -0.00095920838485042987,
        -0.00102849599668884320,
        -0.00107666382392391160,
        -0.00110440386649017310,
        -0.00111269535562794800,
        -0.00110277303360136410,
        -0.00107609290303097120,
        -0.00103429609788266230,
        -0.00097917153167579392,
        -0.00091261797185143234,
        -0.00083660617282604172,
        -0.00075314167467865456,
        -0.00066422884034799789,
        -0.00057183666247525168,
        -0.00047786682247177924,
        -0.00038412443004771024,
        -0.00029229181222750305,
        -0.00020390565800263561,
        -0.00012033775915993316,
        -0.00004277952070817465,
        0.00002776965331457324,
        0.00009051005992020156,
        0.00014484550986655254,
        0.00019038334261406483,
        0.00022693079266485565,
        0.00025448791158547878,
        0.00027323730024736583,
        0.00028353095036881624,
        0.00028587453287296356,
        0.00028090950238253084,
        0.00026939341211198482,
        0.00025217885120873683,
        0.00023019142723817011,
        0.00020440721995288101,
        0.00017583012888083027,
        0.00014546952689584310,
        0.00011431861503039200,
        0.00008333385088421897,
        0.00005341579448396770,
        0.00002539168200764659
    };

    static float x[Ntap2]; //input samples
    float y=0;            //output sample
    int n;
    static int pos;
    x[pos] = NewSample;
    for(n=pos; n<Ntap2; n++) y += FIRCoef[n-pos] * x[n];
    for(n=0; n<pos; n++) y += FIRCoef[Ntap2-pos+n] * x[n];
    pos--; if(pos<0)pos=Ntap2-1;
   
    return y;
}
/////////////////////////////////////////////////////////////////////////////
//---------------------------------------------------------------------------
 void qth2latlon(AnsiString qth, double & lon, double & lat)
 {char a = 65;//ASCI("A");
  char z = 48;//ASCI("0");
  qth = qth.UpperCase();
  char l[7];
  strncpy(l,qth.c_str(),7);
  lon = -90 + 10 * (l[0] - a);
  lon = lon + l[2] - z;
  lon = 2 * (lon + (l[4] - a + 0.5) / 24);
  lat = -90 + 10 * (l[1] - a);
  lat = lat + l[3] - z;
  lat = lat + (l[5] - a + 0.5) / 24;
 }
//---------------------------------------------------------------------------
double calcdist(double lon, double lat, double mylon, double mylat)
{
 double pi = 4.0 * atan(1);
 double rearth = 6371.0;
 double gam = (lon - mylon) * pi / 180;
 double a = mylat * pi / 180;
 double b = lat * pi / 180;
 double cosc = sin(a) * sin(b) + cos(a) * cos(b) * cos(gam);
 double sinc = sqrt(1.0 - cosc * cosc);
 double cc = atan(sinc / cosc);
 if (cc < 0) cc = cc + pi;
 double km = cc * rearth;
 return km;
}
//---------------------------------------------------------------------------

/////////////////////////////////////////////////////////////////////////////////
// ----------------------------------------------------------------------------
// CRC tester v1.3 written on 4th of February 2003 by Sven Reifegerste (zorc/reflex)
// This is the complete compilable C program, consisting only of this .c file.
// No guarantee for any mistakes.
//
// changes to CRC tester v1.2:
//
// - remove unneccessary (!(polynom&1)) test for invalid polynoms
//   (now also XMODEM parameters 0x8408 work in c-code as they should)
//
// changes to CRC tester v1.1:
//
// - include an crc&0crcmask after converting non-direct to direct initial
//   value to avoid overflow
//
// changes to CRC tester v1.0:
//
// - most int's were replaced by unsigned long's to allow longer input strings
//   and avoid overflows and unnecessary type-casting's
// ----------------------------------------------------------------------------

const int order = 16;
const unsigned long polynom = 0x8005;
const int direct = 1;
const unsigned long crcinit = 0x0;
const unsigned long crcxor = 0x0;
const int refin = 1;
const int refout = 1;

// 'order' [1..32] is the CRC polynom order, counted without the leading '1' bit
// 'polynom' is the CRC polynom without leading '1' bit
// 'direct' [0,1] specifies the kind of algorithm: 1=direct, no augmented zero bits
// 'crcinit' is the initial CRC value belonging to that algorithm
// 'crcxor' is the final XOR value
// 'refin' [0,1] specifies if a data byte is reflected before processing (UART) or not
// 'refout' [0,1] specifies if the CRC will be reflected before XOR


// internal global values:

unsigned long crcmask;
unsigned long crchighbit;
unsigned long crcinit_direct;
unsigned long crcinit_nondirect;
unsigned long crctab[256];


// subroutines

unsigned long reflect (unsigned long crc, int bitnum) {

	// reflects the lower 'bitnum' bits of 'crc'

	unsigned long i, j=1, crcout=0;

	for (i=(unsigned long)1<<(bitnum-1); i; i>>=1) {
		if (crc & i) crcout|=j;
		j<<= 1;
	}
	return (crcout);
}





unsigned long crcbitbybitfast(unsigned char* p, unsigned long len) {

	// fast bit by bit algorithm without augmented zero bytes.
	// does not use lookup table, suited for polynom orders between 1...32.

	unsigned long i, j, c, bit;
	unsigned long crc = crcinit_direct;

	for (i=0; i<len; i++) {

		c = (unsigned long)*p++;
		if (refin) c = reflect(c, 8);

		for (j=0x80; j; j>>=1) {

			bit = crc & crchighbit;
			crc<<= 1;
			if (c & j) bit^= crchighbit;
			if (bit) crc^= polynom;
		}
	}

	if (refout) crc=reflect(crc, order);
	crc^= crcxor;
	crc&= crcmask;

	return(crc);
}
/////////////////////////////////////////////////////////////////////////////////
AnsiString op_code(char c[], int v51[])
{
  //    
 if(c[0]==' ') c[0]=0;
 if(c[0]>47 && c[0]<58) c[0]=c[0]-21; // 0...9
 if(c[0]>64 && c[0]<91) c[0]=c[0]-64; // A...Z

 if(c[1]>47 && c[1]<58) c[1]=c[1]-22; // 0...9
 if(c[1]>64 && c[1]<91) c[1]=c[1]-65; // A...Z

 if(c[2]>47 && c[2]<58) c[2]=c[2]-48; // 0...9

 if(c[3]==' ') c[3]=0;
 if(c[3]>64 && c[3]<91) c[3]=c[3]-64; // A...Z

 if(c[4]==' ') c[4]=0;
 if(c[4]>64 && c[4]<91) c[4]=c[4]-64; // A...Z

 if(c[5]==' ') c[5]=0;
 if(c[5]>64 && c[5]<91) c[5]=c[5]-64; // A...Z

 unsigned __int64 map=(((((c[0])*36 + c[1]) * 10 + c[2]) * 27 + c[3]) * 27 + c[4]) * 27 + c[5];
 unsigned short crc;
 unsigned char msg51[4+28+16+3];
 unsigned char arr[28+16+3];
 for(int i=0; i<28; i++) {if(1 & (map>>i)) arr[27-i]='1'; else arr[27-i]='0';}
 crcmask = ((((unsigned long)1<<(order-1))-1)<<1)|1;
 crchighbit = (unsigned long)1<<(order-1);
 crc=crcbitbybitfast(arr, 28);
 unsigned short crc_low,crc_high;
 crc_low=crc&0xff;
 crc_high=(crc>>8)&0xff;
 if(crc_low==0)crc_low=0x1b;
 if(crc_high==0)crc_high=0x2b;
 crc=(crc_low<<8)^crc_high;
 for(int i=0; i<16; i++) {if(1 & (crc>>i)) arr[27+16-i]='1'; else arr[27+16-i]='0';}
 crc=crcbitbybitfast(arr, 28+16);
 crc_low=crc&0xff;
 crc_high=(crc>>8)&0xff;
 if(crc_low==0)crc_low=0x1b;
 if(crc_high==0)crc_high=0x2b;
 crc=(crc_low<<8)^crc_high;
 crc=crc&0x07;
 for(int i=0; i<3; i++) {if(1 & (crc>>i)) arr[27+16+3-i]='1'; else arr[27+16+3-i]='0';}
 unsigned char *nvect="111000010101011111100110110100000001100100010101011";
 for(int i=0; i<28+16+3; i++) msg51[i+4]=arr[i];
 for(int i=0; i<4; i++) msg51[i]='0';
 for(int i=0; i<51; i++)
 { if(msg51[i]==nvect[i]) msg51[i]='0';
   else msg51[i]='1';
 }
 for(int i=0; i<51; i++) v51[i]=msg51[i]-0x30;
 unsigned char wh_coded[17][8];
 for(int i=0; i<51; i=i+3)
 {
  if(strncmp(&msg51[i],"000",3)==0)strncpy(&wh_coded[i/3][0],"0000000",7);
  if(strncmp(&msg51[i],"001",3)==0)strncpy(&wh_coded[i/3][0],"1010101",7);
  if(strncmp(&msg51[i],"010",3)==0)strncpy(&wh_coded[i/3][0],"0110011",7);
  if(strncmp(&msg51[i],"011",3)==0)strncpy(&wh_coded[i/3][0],"1100110",7);
  if(strncmp(&msg51[i],"100",3)==0)strncpy(&wh_coded[i/3][0],"0001111",7);
  if(strncmp(&msg51[i],"101",3)==0)strncpy(&wh_coded[i/3][0],"1011010",7);
  if(strncmp(&msg51[i],"110",3)==0)strncpy(&wh_coded[i/3][0],"0111100",7);
  if(strncmp(&msg51[i],"111",3)==0)strncpy(&wh_coded[i/3][0],"1101001",7);
 }
 unsigned char ilv[17*7];
 int k=0;
 for(int i=0; i<7; i++)
 {
  for(int j=0; j<17; j++) {ilv[k]=wh_coded[j][i];k++;}
 }
 AnsiString operaPIC="11";
 for(int i=0; i<17*7; i++)
 {
  if(ilv[i]=='0') operaPIC+="10"; else operaPIC+="01";
 }
 operaPIC=operaPIC.SubString(1,239);
 return operaPIC;
}
/////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////
int op32opds(float op[], char call[], bool lookup, float & dB, int myn)
{ int detected=0;
  float max=0, sum=0, sum1=0, op_sum=0, sumsn=0;
  int n_max=-1;

  ///////////////////////////////////////////////////
  if(lookup)
  {// -    
   float MaxMax=0; int lookup_shift=0; int MaxMax_N=-1; float lookupdB=-100;
   for(int shift=-CORRELATOR_LOOKUP; shift<CORRELATOR_LOOKUP; shift++)
   {max=0, sum=0, sum1=0, op_sum=0, sumsn=0; n_max=-1;
    for(int n=0; n<nc; n++)
    { if(callslist[n].km==-1 || callslist[n].call=="") continue; //    callsloc.txt
      sum=0; sumsn=0; int tt=2; //2
      for(int i=tt; i<239; i++)
      { int j=i+shift; if(j<tt) continue; if(j>=239) continue;
        int k=(i-tt)*N8192;
        sum=sum + op[k]*callslist[n].pic[j%239];
        sumsn=sumsn+op[k];
      }
      if(sum>max){sum1=max; max=sum; n_max=n; op_sum=sumsn;}
      else {if(sum>sum1 && sum<max){sum1=sum;}}
    }
    if(n_max<0) continue;

    if(sum1>0 && max>(max1max2)*sum1)
    { lookupdB=-99;
      max=max* (237.0)/(237-abs(shift));
      op_sum=op_sum* 237.0/(237-abs(shift));
      try{
       if(max!=0 && op_sum>max){ lookupdB=10.0*log10(fabs(2.0*max/(op_sum-max)));}
         }catch(...){}
     if(lookupdB<dB) continue;
     dB=lookupdB;
     if(max>MaxMax){MaxMax=max; lookup_shift=shift; MaxMax_N=n_max;}
    }
   } //for shift
   AnsiString s;
   if(MaxMax_N!=-1 && dB>opds_threshold)
   { time_t t=time(NULL);
      t=t-lookup_shift*8.192;//N8192; //-
      struct tm *t_cur;
      t_cur=gmtime(&t);
      AnsiString tstr;
      tstr.sprintf("%02u:%02u:%02u",t_cur->tm_hour,t_cur->tm_min,t_cur->tm_sec);
     s.sprintf("LOOK: %s %s %.1f",tstr,callslist[MaxMax_N].call,Fdial+F0 + myn*(100.0/NF));
     Form1->StatusBar1->Panels->Items[4]->Text=s;
   }
   return 0;
  } //if lookup
/////////////////////////////////////////////////

  max=0; sum=0; sum1=0; op_sum=0; sumsn=0; n_max=-1;
  for(int n=0; n<nc; n++)
  { if(callslist[n].km==-1  || callslist[n].call=="") continue; //    callsloc.txt
    sum=0; sumsn=0;  int tt=2; //2
    for(int i=tt; i<239; i++)
    { int j=(i-tt)*N8192;
      sum=sum + op[j]*callslist[n].pic[i];
      sumsn=sumsn+op[j];
    }
    if(sum>max){sum1=max; max=sum; n_max=n; op_sum=sumsn;}
    else {if(sum>sum1 && sum<max){sum1=sum;}}
  }
  if(n_max<0) return 0;

  if(sum1>0 && max>(max1max2)*sum1)
  { dB=-99;
    try{ if(max!=0 && op_sum>max){ dB=10.0*log10(fabs(2.0*max/(op_sum-max)));}
        }catch(...){}

    if(dB<opds_threshold) return 0;

   //  ,  ,          
    float maxShift=0; int  maxShiftN=-1; int detected_shift=0;
       for(int shift=-CORRELATOR_SHIFT; shift<CORRELATOR_SHIFT; shift++)
       { if(shift==0) continue;
         for(int n=0; n<nc; n++)
         {  if(callslist[n].km==-1 || callslist[n].call=="") continue; //    callsloc.txt
            float sum=0;  int tt=2; //2
            for(int i=tt; i<239; i++)
            {int j=i+shift; if(j<tt) continue; if(j>=239) continue;
             int k=(i-tt)*N8192;
             sum=sum + op[k] * callslist[n].pic[j%239];
            }
            //sum=sum * 237.0/(237-abs(shift));   ////////////
            if(sum>maxShift){ maxShift=sum; maxShiftN=n; detected_shift=shift;}
         }
       }//end for shift
     maxShift=maxShift * 237.0/(237-abs(detected_shift)); ///???
     if(max>maxShift)
     {// -   
      strcpy(call, callslist[n_max].call.c_str());
      AnsiString s;
      s.sprintf("OPDS: %s %.1fdB %.1f",call,dB, Fdial+F0 + myn*(100.0/NF));
      Form1->StatusBar1->Panels->Items[4]->Text=s;
      detected=1;
     }
     else //      
     {AnsiString s;
      time_t t=time(NULL);
      t=t-detected_shift*8.192;//N8192;  //-
      struct tm *t_cur;
      t_cur=gmtime(&t);
      AnsiString tstr;
      tstr.sprintf("%02u:%02u:%02u",t_cur->tm_hour,t_cur->tm_min,t_cur->tm_sec);
      s.sprintf("OPDS: %s %s? %.1f",tstr, callslist[maxShiftN].call,Fdial+F0 + myn*(100.0/NF));
      Form1->StatusBar1->Panels->Items[4]->Text=s;
      detected=0;
     }
  }

  return detected;
}
////////////////////////////////////////////////////////////////////////////////
int op32decode(float op[], char op_bin[], char call[], float & dB, int &attempt, float &correlation, int deep, int Tshift, int myn)
{int detected=0;
 int wh[8][14]= {{1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1},  //000 = 0000000  0-> 1,-1  1-> -1, 1
                {-1,1, 1,-1, -1,1, 1,-1, -1,1, 1,-1, -1,1},   //001 = 1010101
                {1,-1, -1,1, -1,1, 1,-1, 1,-1, -1,1, -1,1},   //010 = 0110011
                {-1,1, -1,1, 1,-1, 1,-1, -1,1, -1,1, 1,-1},   //011 = 1100110
                {1,-1, 1,-1, 1,-1, -1,1, -1,1, -1,1, -1,1},   //100 = 0001111
                {-1,1, 1,-1, -1,1, -1,1, 1,-1, -1,1, 1,-1},   //101 = 1011010
                {1,-1, -1,1, -1,1, -1,1, -1,1, 1,-1, 1,-1},   //110 = 0111100
                {-1,1, -1,1, 1,-1, -1,1, 1,-1, 1,-1, -1,1}};  //111 = 1101001
 int scr[51]={1,1,1,0,0,0,0,1,0,1,0,1,0,1,1,1,1,1,1,0,0,1,1,0,1,1,0,1,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,1,0,1,0,1,0,1,1};
 int inf[51];
 int inf1[51],inf2[51];
 int inf_det1[51];
 int n1=0, n2=0;
 unsigned char arr[28+16+3];
 float max=0;
 float op_sum=0;
 float w17[17];
 op_shift=0;
 memset(inf,0,sizeof(inf));
 memset(inf1,0,sizeof(inf1));
 memset(inf2,0,sizeof(inf2));
 memset(inf_det1,0,sizeof(inf_det1));
 memset(w17,0,sizeof(w17));

 //        N8192 (, 4).
 float sum1=0, sumsn1=0;
 float sum14=0, sumsn14=0;
 float sum8=0, sumsn8=0;
 float sum8_1=0;
 int nn1=0, nn2=0;
 for(int k=0; k<17; k++)  //    17   
 { int N_WH=0, N_WH2=0;   //   -,   
   sum8=0; sum8_1=0; sumsn8=0;      //   ()     
   for(int j=0; j<8; j++) //        
   { sum14=0; sumsn14=0;
     for(int i=0; i<14; i=i+2) //   ,      
     {sum1=0; sumsn1=0;
      int shift=Tshift* N8192*i/14;
      { nn1=i*17*N8192 +k*N8192*2 + shift;
        nn2=nn1+N8192;
        sum1=op[nn1]*wh[j][i] + op[nn2]*wh[j][i+1];
        sumsn1=op[nn1]+op[nn2];
      }
      //if(sum>=sum1){sum1=sum;sumsn1=sumsn;op_shift=shift;}
      sum14=sum14+sum1; sumsn14=sumsn14+sumsn1;
     }//end for i
     // sum14 -        .
     //        
     if(sum14>sum8) {sum8_1=sum8; sum8=sum14; sumsn8=sumsn14; N_WH2=N_WH; N_WH=j;}
     else {if(sum14>sum8_1 && sum14<sum8) {sum8_1=sum14; N_WH2=j;}} //        
   }//end for j
    max=max+sum8; //       
    op_sum=op_sum+sumsn8; //   +    
    w17[k]=sum8-sum8_1; //  ()  
   //           
   inf1[k*3]=((N_WH&0x04)>>2)&1; inf1[k*3+1]=((N_WH&0x02)>>1)&1; inf1[k*3+2]=N_WH&0x01;
   inf2[k*3]=((N_WH2&0x04)>>2)&1; inf2[k*3+1]=((N_WH2&0x02)>>1)&1; inf2[k*3+2]=N_WH2&0x01;
 }//end for k

 //  
 for(int i=0; i<51; i++) if(inf1[i]==scr[i])inf1[i]=0; else inf1[i]=1; // XOR
 for(int i=0; i<51; i++) if(inf2[i]==scr[i])inf2[i]=0; else inf2[i]=1; // XOR

 //    ?
 int n_w17_min=0,n_w17_min2=0,n_w17_min3=0,n_w17_min4=0,n_w17_min5=0; float min=MAXFLOAT;
 for(int i=0; i<17; i++){if(w17[i]<min){min=w17[i]; n_w17_min=i;}}
 min=MAXFLOAT;
 for(int i=0; i<17; i++){if(i==n_w17_min)continue; if(w17[i]<min){min=w17[i]; n_w17_min2=i;}}
 min=MAXFLOAT;
 for(int i=0; i<17; i++){if(i==n_w17_min)continue; if(w17[i]<min){min=w17[i]; n_w17_min2=i;}}
 min=MAXFLOAT;
 for(int i=0; i<17; i++){if(i==n_w17_min || i==n_w17_min2)continue; if(w17[i]<min){min=w17[i]; n_w17_min3=i;}}
 min=MAXFLOAT;
 for(int i=0; i<17; i++){if(i==n_w17_min || i==n_w17_min2 || i==n_w17_min3)continue; if(w17[i]<min){min=w17[i]; n_w17_min4=i;}}
 min=MAXFLOAT;
 for(int i=0; i<17; i++){if(i==n_w17_min || i==n_w17_min2 || i==n_w17_min3 || i==n_w17_min4)continue; if(w17[i]<min){min=w17[i]; n_w17_min5=i;}}

 int w17minvalue=0;
 int w17minvalue2=(inf1[n_w17_min2*3] + 2*inf1[n_w17_min2*3+1] + 4*inf1[n_w17_min2*3+2])&7;
 int w17minvalue3=(inf2[n_w17_min3*3] + 2*inf2[n_w17_min3*3+1] + 4*inf2[n_w17_min3*3+2])&7;

 int n_attempt=0;
 int max_attempt=0;
 if(deep==1) max_attempt=82;//26;
 if(deep==2) max_attempt=601;//218; //164
 float wdelta=0;

 //  CRC
 M_WHILE:
 while(detected!=2 && n_attempt<=max_attempt)
 {memcpy(inf,inf1,sizeof(inf));
  if(n_attempt<18 && n_attempt>0)
  {for(int i=(n_attempt-1)*3; i<(n_attempt-1)*3 +3 ; i++) if(i<51 && i>=0)inf[i]=inf2[i];
   wdelta=w17[n_attempt-1];
  }
  if(n_attempt==18) {memcpy(inf,inf2,sizeof(inf));for(int i=0; i<17; i++) wdelta+=w17[i];}
  if(n_attempt>18 && n_attempt<=82) // 26          
  {inf[n_w17_min*3]=w17minvalue&1;
   inf[n_w17_min*3+1]=((w17minvalue&2)>>1)&1;
   inf[n_w17_min*3+2]=((w17minvalue&4)>>2)&1;
   inf[n_w17_min2*3]=w17minvalue2&1;
   inf[n_w17_min2*3+1]=((w17minvalue2&2)>>1)&1;
   inf[n_w17_min2*3+2]=((w17minvalue2&4)>>2)&1;
   w17minvalue++;
   if(w17minvalue>=8)
   { w17minvalue=0;
     w17minvalue2++; w17minvalue2=w17minvalue2&7;
   }
   wdelta=w17[n_w17_min]+w17[n_w17_min2];
  }
  if(n_attempt>82 &&(n2<17 && n1<17) && n_attempt<=218)  //    2- 
  {n2++;if(n2>16){n1++;n2=n1+1;}
   if(n1==n2)continue;
    for(int i=n1*3; i<n1*3 +3 ; i++) if(i<51)inf[i]=inf2[i];
    for(int i=n2*3; i<n2*3 +3 ; i++) if(i<51)inf[i]=inf2[i];
    if(n1==15 && n2==16)
    { n_attempt=218;w17minvalue=0;w17minvalue2=0;}
    wdelta=w17[n1]+w17[n2];
  }
  if(n_attempt>218 && n_attempt<=max_attempt) //       
  {inf[n_w17_min*3]=w17minvalue&1;
   inf[n_w17_min*3+1]=((w17minvalue&2)>>1)&1;
   inf[n_w17_min*3+2]=((w17minvalue&4)>>2)&1;
   inf[n_w17_min2*3]=w17minvalue2&1;
   inf[n_w17_min2*3+1]=((w17minvalue2&2)>>1)&1;
   inf[n_w17_min2*3+2]=((w17minvalue2&4)>>2)&1;
   inf[n_w17_min3*3]=w17minvalue3&1;
   inf[n_w17_min3*3+1]=((w17minvalue3&2)>>1)&1;
   inf[n_w17_min3*3+2]=((w17minvalue3&4)>>2)&1;
   w17minvalue++;
   if(w17minvalue>=8)
   { w17minvalue=0;
     w17minvalue2++;
   }
   if(w17minvalue2>=8)
   { w17minvalue2=0;
     w17minvalue3++; w17minvalue3=w17minvalue3&7;
   }
   wdelta=w17[n_w17_min]+w17[n_w17_min2]+w17[n_w17_min3];
  }
  
  unsigned short crc;
  memset(arr,0,sizeof(arr));
  for(int i=0; i<28; i++) arr[i]=inf[i+4]+0x30;
  crcmask = ((((unsigned long)1<<(order-1))-1)<<1)|1;
  crchighbit = (unsigned long)1<<(order-1);
  crc=crcbitbybitfast(arr, 28);
  unsigned short crc_low,crc_high;
  crc_low=crc&0xff;
  crc_high=(crc>>8)&0xff;
  if(crc_low==0)crc_low=0x1b;
  if(crc_high==0)crc_high=0x2b;
  crc=(crc_low<<8)^crc_high;
  for(int i=0; i<16; i++) {if(1 & (crc>>i)) arr[27+16-i]='1'; else arr[27+16-i]='0';}
  crc=crcbitbybitfast(arr, 28+16);
  crc_low=crc&0xff;
  crc_high=(crc>>8)&0xff;
  if(crc_low==0)crc_low=0x1b;
  if(crc_high==0)crc_high=0x2b;
  crc=(crc_low<<8)^crc_high;
  crc=crc&0x07;
  for(int i=0; i<3; i++) {if(1 & (crc>>i)) arr[27+16+3-i]='1'; else arr[27+16+3-i]='0';}
 
  //  crc
  detected=2;
  for(int i=47-3; i<47; i++) if((arr[i]-0x30) != inf[i+4]) detected=1;
  // ,  4     0
  if(decoder_zero_test){if(inf[0]!=0 || inf[1]!=0 || inf[2]!=0 || inf[3]!=0) detected=1;}
  for(int i=28; i<47-3; i++) if((arr[i]-0x30) != inf[i+4]) detected=0;

  if(detected==1){memcpy(inf_det1,inf,sizeof(inf));}

  n_attempt++;
  if(!deep && n_attempt) break;
 }  //end while

 float ddb=-99.0;
 attempt=n_attempt;
 if(detected)
 {max=max-wdelta; //  -  
  try{
   if(max!=0 && op_sum>max)ddb=10.0*log10(2.0*max/(op_sum-max));
     }catch(...){}

   if(detected==1){memcpy(inf,inf_det1,sizeof(inf));}
   //   
   unsigned __int64 map=0;
   for(int i=0; i<28; i++) {if(inf[i+4]==1)map=(map<<1)+1; else map=map<<1;}
   call[5]=map%27;
   map=(map-call[5])/27;
   call[4]=map%27;
   map=(map-call[4])/27;
   call[3]=map%27;
   map=(map-call[3])/27;
   call[2]=map%10;
   map=(map-call[2])/10;
   call[1]=map%36;
   map=(map-call[1])/36;
   call[0]=map%37;
   call[6]=0;
   if(call[0]==0)call[0]=' ';
   else if(call[0]<27) call[0]=call[0]+64;
        else if(call[0]<37)call[0]=call[0]+21;
   if(call[1]<26) call[1]=call[1]+65;
        else if(call[1]<36)call[1]=call[1]+22;
   call[2]=call[2]+ 48;
   if(call[3]>0) call[3]=call[3]+64;
   if(call[4]>0) call[4]=call[4]+64;
   if(call[5]>0) call[5]=call[5]+64;

   while(call[0]==' '){call[0]=call[1];call[1]=call[2];call[2]=call[3];call[3]=call[4];call[4]=call[5];call[5]=call[6];}

   //--------------
   {  // 
     char fpic[240]; int v51f[52];
     char fcall[10];  memset(fcall,0,sizeof(fcall));
     strcpy(fcall,call);
     AnsiString spic=op_code(fcall,v51f);
     for(int i=0; i<239;i++) {if(spic.SubString(i+1,1)=="1")fpic[i]=1; else fpic[i]=-1; }
     int match=0; int tt=2;
     for(int i=tt; i<239; i++) if(op_bin[(i-tt)*N8192]==fpic[i]) match++;
     correlation=(float)(match-119)*100.0/(237-119); //  
    //////////////
   }
  //----------------
   AnsiString s;
   s.sprintf("DEC: %s %.1fdB %d %.1f",call, ddb, n_attempt, Fdial+F0 + myn*(100.0/NF));
   if(detected)Form1->StatusBar1->Panels->Items[4]->Text=s;
 } // end if detected
 else
 {if(Form1->CorrelationOPDS1->Checked && DEEP_ALLOWED && Tshift==0)
  {
   { //      239
    int maxMatch=0, maxMatchN=-1, max2=0;
    int detected_shift=0;
    for(int n=0; n<nc; n++)
    { if(callslist[n].km==-1 || callslist[n].call=="") continue; //    callsloc.txt
      int match=0; int tt=2;//2
      for(int i=tt; i<239; i++) if(op_bin[(i-tt)*N8192]==callslist[n].pic[i]) match++;
      if(match>maxMatch){max2=maxMatch; maxMatch=match; maxMatchN=n;}
      else {if(match>max2 && match<maxMatch){max2=match;}}
    }
    if(maxMatch>correlator_threshold239 && maxMatchN!=-1 && (maxMatch-max2)>=1) //    
    { //  ,         
       int maxMatchShift=0; int  maxMatchShiftN=-1;
       for(int shift=-CORRELATOR_SHIFT; shift<CORRELATOR_SHIFT; shift++)
       { if(shift==0) continue;
         for(int n=0; n<nc; n++)
         {  if(callslist[n].km==-1) continue; //    callsloc.txt
            int match=0; int tt=2; //2
            for(int i=tt; i<239; i++)
            {int j=i+shift; if(j<tt) continue; if(j>=239) continue;
             if(op_bin[(i-tt)*N8192]==callslist[n].pic[j%239]) match++;
            }
            // match=match* 237.0/(237-abs(shift)); //////////////////
            if(match>maxMatchShift){ maxMatchShift=match; maxMatchShiftN=n; detected_shift=shift;}
         }
       }
   maxMatchShift=maxMatchShift * 237.0/(237-abs(detected_shift));  ////???
     if(maxMatch>maxMatchShift)
     {detected=1; strncpy(call,callslist[maxMatchN].call.c_str(),6);
      call[6]=0;
      attempt=0;
      correlation=(float)(maxMatch-119)*100.0/(237-119); //  
      try{ if(max!=0 && op_sum>max)ddb=10.0*log10(2.0*max/(op_sum-max));}catch(...){}
      AnsiString s;
      s.sprintf("CORR: %s %.1fdB %.1f%% (%d)", call, ddb, correlation, maxMatch);
      Form1->StatusBar1->Panels->Items[4]->Text=s;
     }
     else
     {AnsiString s;
      time_t t=time(NULL);
      t=t-detected_shift*8.192;//N8192; //-
      struct tm *t_cur;
      t_cur=gmtime(&t);
      AnsiString tstr;
      tstr.sprintf("%02u:%02u:%02u",t_cur->tm_hour,t_cur->tm_min,t_cur->tm_sec);
      s.sprintf("CORR: %s %s? %.1f",tstr,callslist[maxMatchShiftN].call,Fdial+F0 + myn*(100.0/NF));
      Form1->StatusBar1->Panels->Items[4]->Text=s;
      detected=0;
     }
    }
   }
   //  ,     ,   
   if(detected==0 && Form1->UseSoftCorrelatorOPDS1->Checked)
   { attempt=-1;
     detected=op32opds(op, call, false, ddb, myn);
     if(detected)   //    fade
     {// 
      char fpic[240]; int v51f[52];
      char fcall[10];  memset(fcall,0,sizeof(fcall));
      strcpy(fcall,call);
      AnsiString spic=op_code(fcall,v51f);
      for(int i=0; i<239;i++) {if(spic.SubString(i+1,1)=="1")fpic[i]=1; else fpic[i]=-1; }
      int match=0; int tt=2;
      for(int i=tt; i<239; i++) if(op_bin[(i-tt)*N8192]==fpic[i]) match++;
      correlation=(float)(match-119)*100.0/(237-119); //  
     }
   }
  } // end if DEEP_ALLOWED
 } // end else
 dB=ddb;
 return detected;
}
/////////////////////////////////////////////////////////////////////////////////
DWORD WINAPI AudioRxThread( LPVOID )
 {CNT_OP=0;
  int CNT_LOOKUP=0;
  bool LOOKUP_ALLOWED=false;
  float lookupdb=0;
  TCIC4 * cic=new TCIC4();
  DEEP_ALLOWED=false;
  processWav=false;
  HANDLE HMUT=OpenMutex(SYNCHRONIZE,false,mutexname);
  if(HMUT==NULL)
   MessageBox(NULL,"Mutex NULL","",MB_OK);
  ph=M_PI/256.0;
  ph2=M_PI/256.0;
  cntDecim=0;
 
  memset(x,0,sizeof(x));memset(x1,0,sizeof(x1)); memset(x2,0,sizeof(x2));
  memset(U,0,sizeof(U));
  memset(Uslow,0,sizeof(Uslow));
  memset(Uthr,0,sizeof(Uthr));
  memset(op_call,0,sizeof(op_call));
  memset(nmax,0,sizeof(nmax));
  memset(blockedlist,0,sizeof(blockedlist));

  int cnt1=0, cnt2=0;
  float Kthr=0.833;

  
  Usred=0.5/CLIP_POROG;
  //    
  for(int n=0; n<NF; n++)
  {float f=100.0 + n*(100.0/NF); // 
   BPF[n]=new TIIRBPF2(f/SND_FD*K12,(float)DF/SND_FD*K12);
   //BPF2[n]=new TIIRBPF2(f/SND_FD*K12,(float)DF2/SND_FD*K12);
  // BPF3[n]=new TIIRBPF2(f/SND_FD*K12,(float)DF/SND_FD*K12);
   LPF[n]=new TIIRLPF(1.5/8.192/SND_FD*K12,1); //1.5//1.1 2.0   ,4
   memset(&OP[n][0],0,(LEN_M_OP+N8192+1)*sizeof(float));
   memset(&OP2[n][0],0,(LEN_M_OP+N8192+1)*sizeof(char));
  }
  //    
  if(F0<5450) filter1=new TFilter((F0-100.0)/SND_FD,(F0+200.0)/SND_FD);
  else filter1=new TFilter((F0-450.0)/SND_FD2,(F0+550.0)/SND_FD2);
  filter2=new TIIRLPF(300.0/SND_FD,3);
  while(1)
  {AUDIO_RX_WORKED=true;
   try{
    if(F0<5450)
    { if(processWav)
     { int len=wf->read(x,x,SND_LEN);
       if(!wf->AvailableRead || len!=SND_LEN)
       {wf->close(); processWav=false;
        Form1->Memo1->Lines->Insert(1,"Done.");
        snd->openIn(SND_FD,16,1,SND_LEN);
        snd->read(x,x,SND_LEN);
       }
     }
     else snd->read(x,x,SND_LEN);
    }
    else ////////// 12500Hz
    {
     if(processWav)
     { int len=wf->read(x2,x2,SND_LEN2);
       if(!wf->AvailableRead || len!=SND_LEN2)
       {wf->close(); processWav=false;
        Form1->Memo1->Lines->Insert(1,"Done.");
        snd->openIn(SND_FD2,16,1,SND_LEN2);
        snd->read(x2,x2,SND_LEN2);
       }
     }
     else snd->read(x2,x2,SND_LEN2);
     //    F0 
     for(int i=0; i<SND_LEN2; i++)
     {
      x[i/4]=(filter1->filter(x2[i])) * cos(ph2);
      ph2=ph2+dph2; if(ph2>TWOPI)ph2=ph2-TWOPI;
     }
    }////////////end 12500
    
     //  
     float uu=0;
     for(int i=0; i<SND_LEN; i++)uu=uu+fabs(x[i]);
     uu=uu/SND_LEN;
     Usred=0.95*Usred+0.05*uu;
     //   
     cntClip=0;
     for(int i=0; i<SND_LEN; i++) if(fabs(x[i])>Usred*CLIP_POROG) {x[i]=0;cntClip++;}
     ////  
    // if(Usred>0){for(int i=0; i<SND_LEN; i++) x[i]=x[i]/(Usred*2.0*CLIP_POROG);}
     // 
  
      if(F0>1430 && F0<1460) for(int i=0; i<SND_LEN; i++) x1[i]=fir1500_12k(x[i]);
      else
      { if(F0>2430 && F0<2460) for(int i=0; i<SND_LEN; i++) x1[i]=fir2500_12k(x[i]);
        else
        { if(F0>1930 && F0<1960)for(int i=0; i<SND_LEN; i++) x1[i]=fir2000_12k(x[i]);
          else
          { if(F0<5450) filter1->filter(x,SND_LEN,x1);
            else for(int i=0; i<SND_LEN; i++) x1[i]=fir1500_12k(x[i]);
          }
        }
      }
    //     
     for(int i=0; i<SND_LEN; i++){x1[i]=x1[i]*cos(ph); ph=ph+dph; if(ph>TWOPI)ph=ph-TWOPI;}
   // 
   // filter2->filter(x1,SND_LEN);
     for(int i=0; i<SND_LEN; i++) x1[i]=fir200(x1[i]);

    //      
    for(int n=0; n<NF; n++)
    {float unew=0; float uthr=0;
     for(int i=N8192; i<LEN_M_OP+N8192;i++) unew=unew+OP[n][i]; //    -  +
     Uslow[n]=unew;
     int n1op2=LEN_M_OP+N8192-1;
     int n2op2=LEN_M_OP+N8192-1-4*N8192;
     Kthr=Kthr+0.00002*(cnt1-cnt2); //      0  1    
     if(Kthr>1.5)Kthr=1.5; if(Kthr<0.5)Kthr=0.5;
     cnt2=cnt1;
     for(int i=n2op2; i<n1op2;i++) uthr=uthr+OP[n][i]; //      
     Uthr[n]=Kthr*uthr/(4*N8192);
    }

    memset(nmax,0,sizeof(nmax));
    int jc=0;
    for(int i=minpkspace; i<NF-minpkspace; i++)
    { bool ismax=true;
      for(int j=1; j<=minpkspace; j++) if(Uslow[i]<Uslow[i+j] ||Uslow[i]<Uslow[i-j]) {ismax=false;break; }
      if(ismax){nmax[i]=1;jc++;}
    }
    //     
     if(Form1->IgnoreLoran1->Checked)
       for(int i=0; i<NF; i++) if(ignorelist[i]){if(nmax[i])jc--; nmax[i]=0;}
    //      
    if(maxNmax>0)
    { int mm=0; int mm_step=NF/maxNmax;
      while(jc>maxNmax)
      {  if(jc-maxNmax<maxNmax)
          {  mm_step=NF/(jc-maxNmax); }
         //   ,      
         int maxcnt=0;
         for(int n=mm; n<mm+mm_step; n++)
         {if(n>=NF)break; if(nmax[n]){maxcnt++;}}
         if(maxcnt>1)  //       ?
         {//      
          float min=MAXFLOAT; int nrmin=NF;
          for(int n=mm; n<=mm+mm_step; n++)
          {  if(n>=NF)break;
             if(nmax[n] && (Uslow[n]<min)){nrmin=n; min=Uslow[n];}
          }
          if(nrmin<NF){nmax[nrmin]=0; jc--;}
         }
         mm=mm+mm_step;
         if(mm>=NF)mm=0;
      }
     }
    //    
     if(Form1->UseFreqList1->Checked)
      for(int i=0; i<NF; i++) if(freqlist[i]) nmax[i]=1;

    // ,     
    for(int i=0; i<NF; i++)
    { if(nmax[i]==1)
      { //       
        float uuuu=0;  int cnt_uuuu=0;
        for(int j=i-50; j<i+50; j++) if(j>=0 && j<NF && abs(j-i)>10 && nmax[j]==0){ uuuu+=Uslow[j];cnt_uuuu++;}
        if(cnt_uuuu>0) uuuu=uuuu/cnt_uuuu;
        if(uuuu>0 && Uslow[i]>0 && 10*log10(Uslow[i]/uuuu)<umax_threshold) nmax[i]=0;
      }
    }

     if(OscillMode)nmax[OscillN]=1; //   ,   
    //   
    jc=0; for(int i=0; i<NF; i++) if(nmax[i])jc++;
    Form1->StatusBar1->Panels->Items[5]->Text=AnsiString(jc)+" peaks";

     //   
     for(int iii=0; iii<SND_LEN; iii=iii+K12)
     {
      if(cntDecim%KDECIM==0){
       CNT_LOOKUP++; LOOKUP_ALLOWED=false;
       if(CNT_LOOKUP%(300)==0)//     (  10 )
       { CNT_LOOKUP=0;LOOKUP_ALLOWED=true; lookupdb=opds_threshold;}
       if(Form1->UseSoftCorrelatorOPDS1->Checked==false) LOOKUP_ALLOWED=false;
                             }
      //       
       //x_op[pos_x_op]=x1[iii];
       //pos_x_op++; if(pos_x_op>=LEN_X_OP)pos_x_op=0;


      //      -   
      for(int n=0; n<NF; n++)
      {float yy=BPF[n]->filter(x1[iii]);
      // if(nmax[n]>0) yy=BPF2[n]->filter(yy);
       //  yy=BPF3[n]->filter(yy);
       if(nmax[n]>0)
        { // using quasycoherent qudrature detector
         float re=yy*cos(BPF[n]->ph); float im=yy*sin(BPF[n]->ph);
         BPF[n]->ph=BPF[n]->ph + BPF[n]->dph;// + BPF[n]->ddph;
         while(BPF[n]->ph > TWOPI)BPF[n]->ph=BPF[n]->ph-TWOPI;
         u0[n]=re*re+im*im;
        }
        else  u0[n]=yy*yy;  // or simple amplitude detector

       U[n]=LPF[n]->filter(u0[n]);

       if(cntDecim%KDECIM==0)
       {//if(!processWav)SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_BELOW_NORMAL);
        memmove(&OP[n][0],&OP[n][1],(LEN_M_OP+N8192-1)*sizeof(float));
        OP[n][LEN_M_OP+N8192-1]=U[n]; 
        memmove(&OP2[n][0],&OP2[n][1],(LEN_M_OP+N8192-1)*sizeof(char));
        if(U[n]>Uthr[n])OP2[n][LEN_M_OP+N8192-1]=1; else OP2[n][LEN_M_OP+N8192-1]=-1;

        if(CNT_OP>N8192*NF*10)
        {if(OP2[n][LEN_M_OP+N8192-1]==1) cnt1++; else cnt1--;  //    0  1   
        }
        CNT_OP++; if(CNT_OP>=LEN_M_OP*NF/2){CNT_OP=LEN_M_OP*NF; DEEP_ALLOWED=true;}else DEEP_ALLOWED=false;
        if(blockedlist[n])blockedlist[n]--;
        //         
          char call[7]; int cc=0; float db=-100.0; float db2=-100.0; float db3=-100.0; int attempt=0;
        //        (   )
         int deep1=0;   float correlation=0;
         if(Form1->DeepDecoder1->Checked) deep1=1;
         //if(Form1->UltraDeepDecoder1->Checked) deep1=2;
         if(Form1->UseFreqList1->Checked && freqlist[n] && Form1->UseKnownCallsList1->Checked) deep1=2; //     ,  ,     calssloc(   false)
         if(OscillMode && OscillN==n)deep1=2;
         
         if(nmax[n]>0 && n>0 && n<NF-1)
         { WaitForSingleObject(HMUT,1000);
           if(decoderDrift) //  ,   
           {float sumd[15]; int nk=n;
            for(int ik=0; ik<15;ik++) sumd[ik]=0;
            for(int ii=0; ii<LEN_M_OP+N8192; ii++)
            { for(int ik=0; ik<15;ik++)
              {if(abs(ik-7)>minpkspace) continue;
               if((n+ik-7)>=0 && (n+ik-7)<NF)sumd[ik]=0.99*sumd[ik]+0.01*OP[n+ik-7][ii];  // 0.995
              }
              float max=0;
              for(int ik=0; ik<15;ik++)
              {if(abs(ik-7)>minpkspace) continue;
               if(sumd[ik]>max){max=sumd[ik]; nk=ik;}
              }
              if((n+nk-7)>=0 && (n+nk-7)<NF) {OP_DRIFT[ii]=OP[n+nk-7][ii];OP2_DRIFT[ii]=OP2[n+nk-7][ii];}
            }
            cc=op32decode(OP_DRIFT, OP2_DRIFT, call, db, attempt, correlation, deep1,0,n);
            if(cc==0) cc=op32decode(&OP[n][0], &OP2[n][0], call, db, attempt, correlation, deep1,0,n);
           } //if decoderDrift
           else cc=op32decode(&OP[n][0], &OP2[n][0], call, db, attempt, correlation, deep1,0,n);
           if(decoderTshift && cc==0)
           {  cc=op32decode(&OP[n][0], &OP2[n][0], call, db, attempt, correlation, deep1,1,n);
              if(cc==0)cc=op32decode(&OP[n][0], &OP2[n][0], call, db, attempt, correlation, deep1,-1,n);
           }
           
           if(DEEP_ALLOWED && LOOKUP_ALLOWED){ char temp[7]; op32opds(&OP[n][0],temp,true,lookupdb,n);} //     
           ReleaseMutex(HMUT);
         }
          //           decoder                                          crrl                                                                    opds
          if((cc>0 && attempt>0 && db>(op_threshold)) || (cc==1 && attempt==0 && db>opds_threshold && blockedlist[n]<=0) || (cc==1 && attempt<0 && db>opds_threshold && blockedlist[n]<=0))
          {  float uuu=0.0;
             for(int i=0; i<NF; i++){if(i>(n-10)&& i<(n+10)) continue; uuu+=Uslow[i];}
             uuu=uuu/(NF-19);
             if(uuu>0)
             { db2=10*log10(Uslow[n]/uuu);
               db3=10*log10(Uslow[n]/uuu/(NF-19));
             }
             // ,          
             WaitForSingleObject(HMUT,1000);
             bool call_found=false;
             for(int i=0; i<N_OPCALL; i++)
             { if(strcmp(call,op_call[i].callsign)==0)
               {time_t t=time(NULL);
                if((op_call[i].db<db && op_call[i].cc==cc) || op_call[i].cc<cc || (op_call[i].correlation<correlation && op_call[i].cc==cc && cc==1) || (op_call[i].cc==cc && cc==2 && op_call[i].attempt>attempt))
                {op_call[i].db=db;
                 op_call[i].t=t;
                 op_call[i].db2=db2;
                 op_call[i].db3=db3;
                 op_call[i].n=n;
                 op_call[i].cc=cc;
                 op_call[i].shift=op_shift;
                 op_call[i].attempt=attempt;
                 op_call[i].correlation=correlation;
                }
                call_found=true; break;
               }
             }
             if(!call_found)
             {int n_free=0; //   
              for(int i=0; i<N_OPCALL; i++) if(op_call[i].callsign[0]==0 ) {n_free=i; break;}
              strncpy(op_call[n_free].callsign, call,6);
              op_call[n_free].db=db;
              op_call[n_free].db2=db2;
              op_call[n_free].db3=db3;
              op_call[n_free].t=time(NULL);
              op_call[n_free].n=n;
              op_call[n_free].cc=cc;
              op_call[n_free].shift=op_shift;
              op_call[n_free].attempt=attempt;
              op_call[n_free].correlation=correlation;
              op_call[n_free].op=true;
             } //if !call_found
            ReleaseMutex(HMUT);
          }//if cc
        //if(!processWav)SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_NORMAL);
        cntDecim=0;
       } //if cntDecim
      }//for n
      cntDecim++;  LOOKUP_ALLOWED=false;
     }//for i
   }catch(...){}
   Sleep(2);
  }
 }
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
 Form1->DoubleBuffered=true;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
  mycall=ini->ReadString("OP-32","MYCALL", "");
  ini->WriteString("OP-32","MYCALL",mycall);
  myqth=ini->ReadString("OP-32","MYQTH", "");
  ini->WriteString("OP-32","MYQTH",myqth);
  myheader=ini->ReadString("OP-32","MYHEADER", "");
  if(myheader=="")myheader.sprintf("%s %s Opera-32 decoded (Op32Rx RN3AUS software)",mycall, myqth);
  ini->WriteString("OP-32","MYHEADER",myheader);
  F0=(ini->ReadFloat("OP-32" ,"F_CENTER",1500.0)) - 50.0;
  if(F0<350.0) F0=350.0; if(F0>23000.0) F0=23000.0;
  ini->WriteFloat("OP-32" ,"F_CENTER",F0+50.0);
  Fdial=ini->ReadFloat("OP-32" ,"F_DIAL",136000.0);
  ini->WriteFloat("OP-32" ,"F_DIAL",Fdial);
  maxNmax=ini->ReadInteger("OP-32","N_MAX",20);
  if(maxNmax<-1)maxNmax=-1; if(maxNmax>NF)maxNmax=NF;
  minpkspace=ini->ReadInteger("OP-32","MIN_PEAK_SPACE",4);
  if(minpkspace<0)minpkspace=0; if(minpkspace>NF/2)minpkspace=NF/2;
  ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
  umax_threshold=ini->ReadFloat("OP-32","PEAK_THRESHOLD",0.4);
  ini->WriteFloat("OP-32","PEAK_THRESHOLD",umax_threshold);
  my_detected=ini->ReadString("OP-32","FILE", "my_detected.txt");
  ini->WriteString("OP-32","FILE",my_detected);
  CaptureSpectrum1->Checked=ini->ReadBool("OP-32","CAPTURE_ENABLE",true);
  ini->WriteBool("OP-32","CAPTURE_ENABLE",CaptureSpectrum1->Checked);
  CaptureFilename=ini->ReadString("OP-32","CAPTURE_FILENAME", "op32rx_capture.jpg");
  ini->WriteString("OP-32","CAPTURE_FILENAME", CaptureFilename);
  capturePath=ini->ReadString("OP-32","CAPTURE_PATH", "Capture\\");
  capturePath=IncludeTrailingBackslash(capturePath);
  if (!DirectoryExists(capturePath))
  {
    if (!CreateDir(capturePath))
      throw Exception("Cannot create "+capturePath+" directory.");
  }
  ini->WriteString("OP-32","CAPTURE_PATH", capturePath);
  commandExecStr=ini->ReadString("OP-32","EXECUTE_IF_DECODED", "");
  ini->WriteString("OP-32","EXECUTE_IF_DECODED", commandExecStr);
  commandExec=ini->ReadBool("OP-32","EXECUTE_IF_DECODED_ENABLE",false);
  ini->WriteBool("OP-32","EXECUTE_IF_DECODED_ENABLE",commandExec);

  int sndIn=ini->ReadInteger("SOUND","DEVICE",-1);
  ini->WriteInteger("SOUND","DEVICE",sndIn);
 
  IgnoreLoran1->Checked=ini->ReadBool("OP-32","IGNORE_LORAN_LINES",false);
  ini->WriteBool("OP-32","IGNORE_LORAN_LINES",IgnoreLoran1->Checked);
  UseFreqList1->Checked=ini->ReadBool("OP-32","USE_FREQUENCY_LIST",true);
  ini->WriteBool("OP-32","USE_FREQUENCY_LIST",UseFreqList1->Checked);
  DeepDecoder1->Checked=ini->ReadBool("OP-32","DEEP_DECODER",true);
  ini->WriteBool("OP-32","DEEP_DECODER",DeepDecoder1->Checked);
  UltraDeepDecoder1->Checked=ini->ReadBool("OP-32","ULTRA_DEEP_DECODER",false);
  ini->WriteBool("OP-32","ULTRA_DEEP_DECODER",UltraDeepDecoder1->Checked);
  UseKnownCallsList1->Checked=ini->ReadBool("OP-32","USE_KNOWN_CALLSLIST",true);
  ini->WriteBool("OP-32","USE_KNOWN_CALLSLIST",UseKnownCallsList1->Checked);
  CoherentDetector1->Checked=ini->ReadBool("OP-32","USE_COHERENT_DETECTOR",false);
  ini->WriteBool("OP-32","USE_COHERENT_DETECTOR",CoherentDetector1->Checked);
  CorrelationOPDS1->Checked=ini->ReadBool("OP-32","USE_CORRELATOR",true);
  ini->WriteBool("OP-32","USE_CORRELATOR",CorrelationOPDS1->Checked);
  UseSoftCorrelatorOPDS1->Checked=ini->ReadBool("OP-32","USE_OPDS",false);
  ini->WriteBool("OP-32","USE_OPDS",UseSoftCorrelatorOPDS1->Checked);
  op_db_shift=ini->ReadFloat("OP-32","OPERA_DB_OFFSET",-10.0);
  ini->WriteFloat("OP-32","OPERA_DB_OFFSET",op_db_shift);
  op_threshold=ini->ReadFloat("OP-32","OP_THRESHOLD",2.2);
  ini->WriteFloat("OP-32","OP_THRESHOLD",op_threshold);
  correlator_threshold239=ini->ReadInteger("OP-32","CORRELATOR_237_THRESHOLD",164);
  ini->WriteInteger("OP-32","CORRELATOR_237_THRESHOLD",correlator_threshold239);
  max1max2=ini->ReadFloat("OP-32","OPDS_MAX1MAX2_THRESHOLD",1.78);
  ini->WriteFloat("OP-32","OPDS_MAX1MAX2_THRESHOLD",max1max2);
  opds_threshold=ini->ReadFloat("OP-32","OPDS_THRESHOLD",2.2);
  ini->WriteFloat("OP-32","OPDS_THRESHOLD",opds_threshold);
  T_CALL_BLOCK=ini->ReadInteger("OP-32","TIME_CALL_BLOCKED",600);
  ini->WriteInteger("OP-32","TIME_CALL_BLOCKED",T_CALL_BLOCK);
  reverse_output=ini->ReadBool("OP-32","REVERSE_OUTPUT",true);
  ini->WriteBool("OP-32","REVERSE_OUTPUT",reverse_output);
  decoder_zero_test=ini->ReadBool("OP-32","DECODER_ZERO_TEST",true);
  ini->WriteBool("OP-32","DECODER_ZERO_TEST",decoder_zero_test);
  decoderDrift=ini->ReadBool("OP-32","DECODER_DRIFT_TRACKING",true);
  ini->WriteBool("OP-32","DECODER_DRIFT_TRACKING",decoderDrift);
  FreqDriftDecoderTracking1->Checked=decoderDrift;
  decoderTshift=ini->ReadBool("OP-32","DECODER_SR_COMPENSATION",true);
  ini->WriteBool("OP-32","DECODER_SR_COMPENSATION",decoderTshift);
  SampleRateOffsetCompensateDecoder1->Checked=decoderTshift;
  Oscillogramm1->Checked=ini->ReadBool("OP-32","OSCILLOGRAM_VISIBLE",true);
  ini->WriteBool("OP-32","OSCILLOGRAM_VISIBLE",Oscillogramm1->Checked);
  Spectrum1->Checked=ini->ReadBool("OP-32","SPECTRUM_VISIBLE",true);
  ini->WriteBool("OP-32","SPECTRUM_VISIBLE",Spectrum1->Checked);
  waterfalContrast=ini->ReadInteger("OP-32","WATERFALL_CONTRAST",0);
  if(waterfalContrast<0)waterfalContrast=0; if(waterfalContrast>2)waterfalContrast=2;
  ini->WriteInteger("OP-32","WATERFALL_CONTRAST",waterfalContrast);
  oscillogrammMode=ini->ReadInteger("OP-32","OSCILL_MODE",0);
  if(oscillogrammMode<0)oscillogrammMode=0; if(oscillogrammMode>2)oscillogrammMode=2;
  ini->WriteInteger("OP-32","OSCILL_MODE",oscillogrammMode);
  OscillN=ini->ReadInteger("OP-32","OSCILL_N",-1);
  ini->WriteInteger("OP-32","OSCILL_N",OscillN);
  AnsiString hn=ini->ReadString("PSKREPORTER","HOSTNAME","report.pskreporter.info");
  ini->WriteString("PSKREPORTER","HOSTNAME",hn);
  AnsiString pp=ini->ReadString("PSKREPORTER","PORT","4739");
  ini->WriteString("PSKREPORTER","PORT",pp);
  hn.WideChar(Rep.hostname,256);
  pp.WideChar(Rep.port,32);
  UploadSpot1->Checked=ini->ReadBool("PSKREPORTER","UPLOAD_SPOT",true);
  ini->WriteBool("PSKREPORTER","UPLOAD_SPOT",UploadSpot1->Checked);
  uploadcorrelatoropdsspots1->Checked=ini->ReadBool("PSKREPORTER","UPLOAD_OPDS_SPOT",false);
  ini->WriteBool("PSKREPORTER","UPLOAD_OPDS_SPOT",uploadcorrelatoropdsspots1->Checked);
  OperaChatSpots1->Checked=ini->ReadBool("OPERA_CHAT","VISIBLE",true);
  ini->WriteBool("OPERA_CHAT","VISIBLE",OperaChatSpots1->Checked);
  UploadSpotstoOPERAcluster1->Checked=ini->ReadBool("OPERA_CHAT","UPLOAD_SPOT",true);
  ini->WriteBool("OPERA_CHAT","UPLOAD_SPOT",UploadSpotstoOPERAcluster1->Checked);
 delete ini;


 WAVEINCAPS pwic;
 int n=waveInGetNumDevs();
 for(unsigned int i=0; i<n; i++)
 { waveInGetDevCaps(i,&pwic,sizeof(pwic));
   AnsiString DevName=pwic.szPname;
   switch(i)
   {case 0: device01->Caption=DevName; device01->Visible=true; if(i==sndIn)device01->Checked=true;break;
    case 1: device11->Caption=DevName; device11->Visible=true; if(i==sndIn)device11->Checked=true;break;
    case 2: device21->Caption=DevName; device21->Visible=true; if(i==sndIn)device21->Checked=true;break;
    case 3: device31->Caption=DevName; device31->Visible=true; if(i==sndIn)device31->Checked=true;break;
    case 4: device41->Caption=DevName; device41->Visible=true; if(i==sndIn)device41->Checked=true;break;
    case 5: device51->Caption=DevName; device51->Visible=true; if(i==sndIn)device51->Checked=true;break;
    case 6: device61->Caption=DevName; device61->Visible=true; if(i==sndIn)device61->Checked=true;break;
    case 7: device71->Caption=DevName; device71->Visible=true; if(i==sndIn)device71->Checked=true;break;
    case 8: device81->Caption=DevName; device81->Visible=true; if(i==sndIn)device81->Checked=true;break;
   }
 }
  if(sndIn!=-1)
  {waveInGetDevCaps(sndIn,&pwic,sizeof(pwic));
   AnsiString DevName=pwic.szPname;
   StatusBar1->Panels->Items[4]->Text=DevName;
  }
  else StatusBar1->Panels->Items[4]->Text="default";
  snd=new TSound();
  snd->IN_DEVICE=sndIn;
  if(F0<5450) snd->openIn(SND_FD,16,1,SND_LEN);
  else snd->openIn(SND_FD2,16,1,SND_LEN2);
    snd->openOut(SND_FD,16,1,SND_LEN);
  if(F0<5450) {dph=TWOPI*(F0-100.0)/SND_FD; dph2=0;}
  else {dph=TWOPI*(1500.0-100.0)/SND_FD; dph2=TWOPI*(F0-1500.0)/SND_FD2;}
  ///
  wf=new TWaveFile();
  //// loading call and locations
  {
  FILE * fp=fopen("callsloc.txt","r");
  if(fp!=NULL)
  {nc=0;
   char in[40];
   char qth[7];
   char call[7];
   double mylat=0, mylon=0, lon=0, lat=0, km=-1;
   qth2latlon(myqth,mylon,mylat);
   while(feof(fp)==0 && nc<N_OPCALL)
   {
     memset(in,0,sizeof(in)); memset(qth,0,sizeof(qth));
    try{
     memset(in,0,sizeof(in)); memset(qth,0,sizeof(qth));   memset(call,0,sizeof(call));
     fgets(in,40,fp);
     if(!isalpha(in[0]) && !isdigit(in[0])) continue;
     callslist[nc].call=AnsiString(strtok(in," \n\r\t"));
     strncpy(call,callslist[nc].call.c_str(),6);
     callslist[nc].call=AnsiString(call);
     strncpy(qth,strtok(NULL," \n\r\t"),6);
     qth2latlon(qth,lon,lat);
     callslist[nc].km=calcdist(lon,lat,mylon,mylat);
     callslist[nc].qth=AnsiString(qth);
     AnsiString pic=op_code(call,callslist[nc].v51);
     for(int i=0; i<239;i++)
     {if(pic.SubString(i+1,1)=="1")callslist[nc].pic[i]=1; else callslist[nc].pic[i]=-1; }
     nc++; if(nc>=N_OPCALL){nc=N_OPCALL-1; break;}
      } catch(...){break;}
    }
  }
  fclose(fp);
  }
  ////// end loading callsloc

 //// loading call from knowncall
  {
  FILE * fp=fopen("known_list.txt","r");
  if(fp!=NULL)
  {char in[40];
   char call[7];
   while(feof(fp)==0 && nc<N_OPCALL)
   {
    try{
     memset(in,0,sizeof(in)); memset(call,0,sizeof(call));
     fgets(in,40,fp);
     if(!isalpha(in[0]) && !isdigit(in[0])) continue;
     callslist[nc].call=AnsiString(strtok(in," \n\r\t"));
     strncpy(call,callslist[nc].call.c_str(),6);
     callslist[nc].km=-1;
     callslist[nc].qth="";
     AnsiString pic=op_code(call,callslist[nc].v51);
     for(int i=0; i<239;i++)
     {if(pic.SubString(i+1,1)=="1")callslist[nc].pic[i]=1; else callslist[nc].pic[i]=-1; }
     nc++; if(nc>=N_OPCALL){nc=N_OPCALL-1; break;}
      } catch(...){break;}
    }
  }
  fclose(fp);
  }
  ////// end loading knowncall


  ////// loading loran lines
  { memset(ignorelist,0,sizeof(ignorelist));
    FILE * fp=fopen("loran_lines.txt","r");
    char in[40];
    if(fp!=NULL)
    { memset(in,0,sizeof(in));
      while(feof(fp)==0)
      { try{
         memset(in,0,sizeof(in));
         fgets(in,40,fp);
         if(!isdigit(in[0])) continue;
         float f1=atof(strtok(in," \n\r\t"));
         if(f1>=137450.0 && f1<=137550.0)
         {int nf=NF*(f1 - Fdial - F0)/100.0;
          if(nf<NF && nf>=0)ignorelist[nf]=1;
         }
        }catch(...){}
      }
    }
    fclose(fp);
  }
  ////// end loading Loran lines

  ////// loading frequency list
  { memset(freqlist,0,sizeof(freqlist));
    FILE * fp=fopen("freq_list.txt","r");
    char in[40];
    if(fp!=NULL)
    { memset(in,0,sizeof(in));
      while(feof(fp)==0)
      { try{
         memset(in,0,sizeof(in));
         fgets(in,40,fp);
         if(!isdigit(in[0])) continue;
         float f1=atof(strtok(in," \n\r\t"));
         if(f1>=137450.0 && f1<=137550.0)
         {int nf=NF*(f1 - Fdial - F0)/100.0;
          if(nf<NF && nf>=0)freqlist[nf]=1;
         }
        }catch(...){}
      }
    }
    fclose(fp);
  }
  ////// end loading freq list
  StatusBar1->Panels->Items[0]->Text="Dial="+AnsiString(Fdial)+ "Hz";
  StatusBar1->Panels->Items[1]->Text="Fc="+AnsiString(F0+50.0)+ "Hz";
  StatusBar1->Panels->Items[5]->Text=AnsiString(maxNmax)+"/"+AnsiString(NF);
  if(UploadSpot1->Checked) StatusBar1->Panels->Items[7]->Text="UPLOAD";
   else StatusBar1->Panels->Items[7]->Text="";

  N01->Caption=N01->Caption + " (" +AnsiString(100.0*0/NF)+" Hz)";
  N11->Caption=N11->Caption + " (" +AnsiString(100.0*1/NF)+" Hz)";
  N21->Caption=N21->Caption + " (" +AnsiString(100.0*2/NF)+" Hz)";
  N31->Caption=N31->Caption + " (" +AnsiString(100.0*3/NF)+" Hz)";
  N41->Caption=N41->Caption + " (" +AnsiString(100.0*4/NF)+" Hz)";
  N51->Caption=N51->Caption + " (" +AnsiString(100.0*5/NF)+" Hz)";
  N61->Caption=N61->Caption + " (" +AnsiString(100.0*6/NF)+" Hz)";
  N71->Caption=N71->Caption + " (" +AnsiString(100.0*7/NF)+" Hz)";
  N81->Caption=N81->Caption + " (" +AnsiString(100.0*8/NF)+" Hz)";
  N91->Caption=N91->Caption + " (" +AnsiString(100.0*9/NF)+" Hz)";
  N102->Caption=N102->Caption + " (" +AnsiString(100.0*10/NF)+" Hz)";

  switch(minpkspace)
  {case 0: N01->Checked=true; break;
   case 1: N11->Checked=true; break;
   case 2: N21->Checked=true; break;
   case 3: N31->Checked=true; break;
   case 4: N41->Checked=true; break;
   case 5: N51->Checked=true; break;
   case 6: N61->Checked=true; break;
   case 7: N71->Checked=true; break;
   case 8: N81->Checked=true; break;
   case 9: N91->Checked=true; break;
   case 10: N102->Checked=true; break;
   default:{
    user1->Caption=AnsiString(minpkspace)+ " (" +AnsiString(DF*minpkspace)+" Hz)";;
    user1->Checked=true;
    user1->Visible=true;
    user_minpkspace=minpkspace;
           }
  }

  switch(maxNmax)
  { case -1: case 0: auto1->Checked=true; break;
    case 10: N101->Checked=true; break;
    case 20: N201->Checked=true; break;
    case 30: N301->Checked=true; break;
    case 40: N401->Checked=true; break;
    case 50: N501->Checked=true; break;
    case 60: N601->Checked=true; break;
    case 70: N701->Checked=true; break;
    case 80: N801->Checked=true; break;
    case 90: N901->Checked=true; break;
    case 100: N1001->Checked=true; break;
    default: {
     user2->Caption=AnsiString(maxNmax);
     user_maxNmax=maxNmax;
     user2->Checked=true;
     user2->Visible=true;
             }
  }
  switch(oscillogrammMode)
  { case 0: Oscillogramm2->Checked=true; break;
    case 1: FilterDetectorChannelOutput1->Checked=true; break;
    case 2: QRSSViewer1->Checked=true; break;
    default: Oscillogramm2->Checked=true;
  }
  ///////
  userdB1->Visible=true;  userdB1->Checked=true;
  userdB1->Caption=AnsiString(umax_threshold)+" dB";
  if(umax_threshold==0) {N0dBnothreshold1->Checked=true;userdB1->Visible=false;}
  if(umax_threshold==0.2) {N02dB1->Checked=true;userdB1->Visible=false;}
  if(umax_threshold==0.4) {N04dB1->Checked=true;userdB1->Visible=false;}
  if(umax_threshold==0.6) {N08dB1->Checked=true;userdB1->Visible=false;}
  if(umax_threshold==0.8) {N11dB1->Checked=true;userdB1->Visible=false;}
  if(umax_threshold==1.0) {N15dB1->Checked=true;userdB1->Visible=false;}
  if(umax_threshold==1.2) {N20dB1->Checked=true;userdB1->Visible=false;}
  if(umax_threshold==1.5) {N25dB1->Checked=true;userdB1->Visible=false;}
  ///////
  Image1->Visible=Oscillogramm1->Checked;
  Image2->Visible=Spectrum1->Checked;
  Waterfall1->Checked=true;
  Image3->Visible=Waterfall1->Checked;
  if(Image1->Visible==false)
  { if(Image2->Visible) {Image2->Top=0;Image3->Top=42;}
    else {Image3->Top=0;}
  }
  else
  {
   if(Image2->Visible){Image2->Top=42;Image3->Top=84;}
   else{Image3->Top=42;}
   Image1->Top=0;
  }
  //
  if(Image2->Visible==false)
  { if(Image1->Visible) {Image1->Top=0;Image3->Top=42;}
    else {Image3->Top=0;}
  }
  else
  {
  if(Image1->Visible){Image2->Top=42;Image3->Top=84;}
  else{Image3->Top=42;}
  Image1->Top=0;
  }
 ////////////
  if(mycall=="" || myqth=="")
  { MessageBox(NULL,"Please set Your CALL and QTH in config file Op32Rx.ini\n(fields MYCALL and MYQTH)","CALL and QTH not set",MB_OK|MB_ICONWARNING);
    UploadSpot1->Checked=false;
  }

  Memo1->ReadOnly=true;
  Memo1->Lines->Add("   DATE     TIME     CALL    FREQ       QRB     Eb/No     SNR   DEC    FADE");
  if(!FileExists(my_detected))
  { FILE *fp=fopen(my_detected.c_str(),"w");
    if(fp)
    {
     fprintf(fp,"%s\n\n",myheader.c_str());
     fprintf(fp,"   DATE     TIME     CALL    FREQ       QRB     Eb/No     SNR   DEC    FADE\n");
    }
    fclose(fp);
  }
  Image3->Canvas->Brush->Color=clGray;
  Image3->Canvas->FloodFill(0,0,clBlack,fsBorder);
  switch(waterfalContrast)
  {case 0: Low1->Checked=true; break;
   case 1: Medium1->Checked=true; break;
   case 2: High1->Checked=true; break;
   default: Low1->Checked=true;
  }

   {randomize();
    time_t t;
    srand((unsigned) time(&t));
   }

  memset(mutexname,0,sizeof(mutexname));
  do{
   AnsiString mxn="Op32RxMutex_";
   mxn=mxn+AnsiString(rand()%1000);
   strcpy(mutexname,mxn.c_str());
   HMUT1=CreateMutex(NULL,FALSE,mutexname);
  }while(HMUT1==NULL || GetLastError()== ERROR_ALREADY_EXISTS);
  DWORD RxThreadId;
  AUDIO_RX_WORKED=false;
  hAudioRx=CreateThread(NULL,0,AudioRxThread,0,CREATE_SUSPENDED,&RxThreadId);
  SetThreadPriority(hAudioRx, THREAD_PRIORITY_NORMAL);
  if(!AUDIO_RX_WORKED){ResumeThread(hAudioRx);}

  if(UploadSpot1->Checked)ReporterInitialize(Rep.hostname,Rep.port);
  if(UploadSpot1->Checked) reporterSendReport(mycall,myqth,Fdial+F0+50,0);
  YYY=2*Image3->Canvas->TextHeight("137500");
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
 Timer1->Enabled=false;
 float Um=0, UUsr=0;
 //  
 if(Oscillogramm1->Checked)
 {
 if(OscillMode==0 || oscillogrammMode==0) //   
 { Image1->Canvas->Brush->Color= clBlack;
   Image1->Canvas->Pen->Color= clBlack;
   Image1->Canvas->FillRect(Rect(0,0,Image1->Width,Image1->Height));
   Image1->Canvas->MoveTo(0, Image1->Height/2);
   Image1->Canvas->Brush->Color= clGreen;
   Image1->Canvas->Pen->Color= clGreen;
   if(cntClip>SND_LEN/20)
   {
    Image1->Canvas->Brush->Color= clRed;
    Image1->Canvas->Pen->Color= clRed;
   }
   float ux=0;  int M=1;
   for(int i=0; i<Image1->Width; i++) {if(fabs(x[M*i])>ux)ux=fabs(x[M*i]);}
   if(ux>0)
    for(int i=0; i<Image1->Width; i++)
     Image1->Canvas->LineTo(i,Image1->Height/2-0.9*x[M*i]/ux*Image1->Height/2);
 }
 else  //       
 { if(oscillogrammMode==1 || oscillogrammMode==0)
   {Image1->Canvas->Brush->Color= clBlack;
    Image1->Canvas->Pen->Color= clBlack;
    Image1->Canvas->FillRect(Rect(0,0,Image1->Width,Image1->Height));
    Image1->Canvas->MoveTo(Image1->Width, Image1->Height-1);
    Image1->Canvas->Brush->Color= clYellow;
    Image1->Canvas->Pen->Color= clYellow;
    float op_max=0;
    for(int i=0; i<(LEN_M_OP+N8192-1); i++) if(OP[OscillN][i]>op_max) op_max= OP[OscillN][i];      ///////
    if(!(op_max>0)) op_max=1.0;
    for(int i=0; i<Image1->Width; i++)
    {int n=i* LEN_M_OP / N8192 *2;
     n=n/Image1->Width;
     if(n>LEN_M_OP+N8192-1)n=LEN_M_OP+N8192-1;
     Image1->Canvas->LineTo(Image1->Width-i,Image1->Height*(1.0-OP[OscillN][LEN_M_OP+N8192-1 - n]/op_max)-1);
    }
    ////   
    Image1->Canvas->MoveTo(Image1->Width-0, Image1->Height*(1.0-Uthr[OscillN]/op_max)-1);
    Image1->Canvas->Brush->Color= clRed;
    Image1->Canvas->Pen->Color= clRed;
    Image1->Canvas->LineTo(Image1->Width-5,Image1->Height*(1.0-Uthr[OscillN]/op_max)-1);
    ////
   }
   cnt_qrss_mode++;
   if(oscillogrammMode==2 && cnt_qrss_mode%(N8192*1000/Timer1->Interval)==0)
   { cnt_qrss_mode=0;
     float op_max=0;
     for(int j=0; j<Image1->Height; j++)
     { int n=OscillN-j+Image1->Height/2;
       if(n<0)n=0; if(n>=NF)n=NF-1;
       for(int i=0; i<Image1->Width;i++)
       { float yy=OP[n][LEN_M_OP+N8192-1 - i];
         if(yy>op_max) op_max=yy;
       }
     }
     for(int j=0; j<Image1->Height; j++)
     { int n=OscillN-j+Image1->Height/2;
       if(n<0)n=0; if(n>=NF)n=NF-1;
       for(int i=0; i<Image1->Width;i++)
       { float yy=OP[n][LEN_M_OP+N8192-1 - i]/op_max;
         switch(waterfalContrast)
        { case 0: yy=sqrt(sqrt(yy));break;
          case 1: yy=sqrt(yy);break;
          case 2: yy=yy;break;
          default: yy=sqrt(yy);
        }
        Image1->Canvas->Brush->Color= RGB(0+128*(yy),0+128*(yy),0+255*(yy));
        Image1->Canvas->Pen->Color= RGB(0+128*(yy),0+128*(yy),0+255*(yy));
        Image1->Canvas->LineTo(Image1->Width-i,j);
       }
       Image1->Canvas->MoveTo(Image1->Width,j);
     }
   }
 }
 }//if checked
 //  
  for(int n=0; n<NF; n++) {if(U[n]>Um)Um=U[n];}
  if(Um<=0)Um=1;

 if(Spectrum1->Checked)
 {Image2->Canvas->Brush->Color= clGray;
  Image2->Canvas->Pen->Color= clGray;
  Image2->Canvas->FillRect(Rect(0,0,Image2->Width,Image2->Height));

  //    
  Image2->Canvas->Brush->Color= clNavy;
  Image2->Canvas->Pen->Color= clNavy;
  Image2->Canvas->MoveTo(0, Image2->Height);

  for(int n=0; n<NF; n++)
  { int i=n* Image2->Width /NF;
    Image2->Canvas->LineTo(i, Image2->Height*(1.0-sqrt(U[n]/Um)));
    if(OscillMode>0 && OscillN==n)
    { TPoint CurPos=Image2->Canvas->PenPos;
      Image2->Canvas->Brush->Color= clYellow;
      Image2->Canvas->Pen->Color= clYellow;
      Image2->Canvas->Rectangle(CurPos.x-2,CurPos.y-2,CurPos.x+2,CurPos.y+2);
      Image2->Canvas->MoveTo(CurPos.x,CurPos.y);
      Image2->Canvas->Brush->Color= clNavy;
      Image2->Canvas->Pen->Color= clNavy;
    }
    if(IgnoreLoran1->Checked && ignorelist[n] || blockedlist[n])
    { TPoint CurPos=Image2->Canvas->PenPos;
       Image2->Canvas->Brush->Color= clBlack;
       Image2->Canvas->Pen->Color= clBlack;
       Image2->Canvas->MoveTo(CurPos.x,0);
       Image2->Canvas->LineTo(CurPos.x,4);
       Image2->Canvas->MoveTo(CurPos.x,CurPos.y);
       Image2->Canvas->Brush->Color= clNavy;
       Image2->Canvas->Pen->Color= clNavy;
    }
    if(nmax[n]>0 && blockedlist[n]<=0)
      {TPoint CurPos=Image2->Canvas->PenPos;
       Image2->Canvas->Brush->Color= clLime;
       Image2->Canvas->Pen->Color= clLime;
       Image2->Canvas->MoveTo(CurPos.x,0);
       Image2->Canvas->LineTo(CurPos.x,4);
       Image2->Canvas->MoveTo(CurPos.x,CurPos.y);
       Image2->Canvas->Brush->Color= clNavy;
       Image2->Canvas->Pen->Color= clNavy;
      }
  }
  //  
  Image2->Canvas->Brush->Color= clRed;
  Image2->Canvas->Pen->Color= clRed;
  Image2->Canvas->MoveTo(0, Image2->Height);
  float max=0;
   for(int n=0; n<NF; n++) if(Uslow[n]>max)max=Uslow[n];
   if(max<=0)max=1;
   for(int i=0; i<Image2->Width; i++)
  {  int n=i* NF / Image2->Width;
    Image2->Canvas->LineTo(i, Image2->Height*(1.0-sqrt(Uslow[n]/max)));
  }
 }

 // 
 if(Waterfall1->Checked)
 {if(cntImage3>8192/Timer1->Interval)
  {cntImage3=0;    // YYY -         
   Image3->Canvas->CopyRect(Rect(0,YYY+1,Image3->Width,Image3->Height), Image3->Canvas, Rect(0,YYY+0,Image3->Width,Image3->Height-1));
   Image3->Canvas->MoveTo(0, YYY+0);
   for(int i=0; i<Image3->Width; i++)
   {  int n=i* NF / Image3->Width;
     float yy;
     switch(waterfalContrast)
     { case 0: yy=sqrt(sqrt(U[n]/Um));break;
       case 1: yy=sqrt(U[n]/Um);break;
       case 2: yy=U[n]/Um;break;
       default: yy=sqrt(sqrt(U[n]/Um));
     }
     //if(yy>1)yy=1;
     Image3->Canvas->Brush->Color=RGB(0+128*(yy),0+128*(yy),0+256*(yy));
     Image3->Canvas->Pen->Color=RGB(0+128*(yy),0+128*(yy),0+256*(yy));
     Image3->Canvas->LineTo(i,YYY+0);
   }
   //  
   { YYY=2*Image3->Canvas->TextHeight("137500");
     Image3->Canvas->Brush->Color= clWhite;
     Image3->Canvas->Pen->Color= clWhite;
     Image3->Canvas->FillRect(Rect(0,0,Image3->Width,YYY));
     Image3->Canvas->Brush->Color= clWhite;
     Image3->Canvas->Pen->Color= clBlack;
     for(int f=1; f<100; f++)
     { int x= f * Image3->Width/100;
       int nx=NF * x/Image3->Width;
       AnsiString s;
       s.sprintf("%.0f", Fdial+F0 + nx*(100.0/NF));
       Image3->Canvas->MoveTo(x,YYY-YYY/4);
       if(f%5==0) Image3->Canvas->MoveTo(x,YYY-YYY/3);
       if(f%10==0) Image3->Canvas->MoveTo(x,YYY-YYY/2);
       Image3->Canvas->LineTo(x,YYY);
       if(f%10==0)
       {int tw=Image3->Canvas->TextWidth(s);
        int th=Image3->Canvas->TextHeight(s);
        Image3->Canvas->Font->Color=clBlack;
        Image3->Canvas->Brush->Style = bsClear;
        Image3->Canvas->TextOut(x-tw/2,0,s);
        Image3->Canvas->Brush->Style = bsSolid;
       }
     }
     //     
     time_t t_label=time(NULL);
     struct tm *t_cur;
     t_cur=gmtime(&t_label);
     if((t_label-t_label_old>=600 || t_label<t_label_old)&&(t_cur->tm_min%10==0))
     { t_label_old=t_label;
       AnsiString label_time;
       label_time.sprintf("%02u:%02u",t_cur->tm_hour,t_cur->tm_min);
       int tw=Image3->Canvas->TextWidth(label_time);
       int th=Image3->Canvas->TextHeight(label_time);
       Image3->Canvas->Pen->Color= clWhite;
       Image3->Canvas->MoveTo(0,YYY);
       Image3->Canvas->LineTo(tw+5,YYY);
       Image3->Canvas->Font->Color=clWhite;
       Image3->Canvas->Brush->Color=clBlack;
       Image3->Canvas->Pen->Color=clBlack;
       Image3->Canvas->Brush->Style = bsClear;
       Image3->Canvas->TextOut(1,1+YYY,label_time);
       Image3->Canvas->Brush->Style = bsSolid;
     }
   }
  }  else cntImage3++;
 }
 

 //       ,        
  time_t t=time(NULL);
  try{
    if(t%20==0 && UploadSpot1->Checked)
    {if(t%1200==0 && Usred>0) reporterSendReport(mycall,myqth,Fdial+F0+50,20*log10(Usred)); //self spot periodicaly
     ReporterTickle();
    }
  }catch(...){}

 WaitForSingleObject(HMUT1,2000);
 bool decoded=false;
  for(int i=0; i<N_OPCALL; i++)
  { if(op_call[i].t>0 && (t-op_call[i].t)>10)
    { char symbol=' ';
      if(op_call[i].cc==1) symbol='?';
      if(op_call[i].cc==1 && op_call[i].attempt==0) symbol='c';
      if(op_call[i].cc==1 && op_call[i].attempt==-1) symbol='d';
      if(symbol=='c' || symbol=='d')
      {if((t-op_call[i].t)<240) continue; // opds  crrl - ,      
       //
      }
      else //   ,         
      {
        for(int g=0; g<N_OPCALL; g++)  // g - ghost -  
        {if(g==i)continue;
         if(op_call[g].t==0) continue;
         if((abs(op_call[i].n - op_call[g].n)< minpkspace+1) && op_call[g].callsign[0]!=0 && op_call[g].cc<2) //    
         {StatusBar1->Panels->Items[4]->Text="FALSE: "+ AnsiString(op_call[g].callsign);
          op_call[g].callsign[0]=0;
          op_call[g].callsign[0]=0;
          op_call[g].t=0;
          op_call[g].db=0; op_call[g].db2=0;
          op_call[g].n=0; op_call[g].cc=0;
          op_call[g].correlation=0;
          op_call[g].op=false;
         }// 
        } // end for g //              
      }
      struct tm *t_cur;
      // t_cur=gmtime(&t);
      t_cur=gmtime(&op_call[i].t);
      AnsiString tstr,opdstr,opstr,kmstr;

      tstr.sprintf("%04u-%02u-%02u %02u:%02u:%02u %6s %.2f ",t_cur->tm_year+1900,t_cur->tm_mon+1,t_cur->tm_mday,t_cur->tm_hour,t_cur->tm_min,t_cur->tm_sec,op_call[i].callsign,Fdial+F0 + op_call[i].n*(100.0/NF));
      // 
      int km=-1;
      bool known_callsign=false;
      AnsiString qth;
      for(int jj=0; jj<nc; jj++)
      { if(strcmp(callslist[jj].call.c_str(),op_call[i].callsign)==0 && (t-callslist[jj].t)>T_CALL_BLOCK) //       
        {callslist[jj].t=t;
         km=floor(callslist[jj].km);qth=callslist[jj].qth;
         if(callslist[jj].km<0) km=-1;
         known_callsign=true;
         callslist[jj].n_repeat++;
         if(km<=0 && (abs(callslist[jj].nf-op_call[i].n)>20)) callslist[jj].n_repeat=1; // freq_prev!=freq_nov don't save new callsign
         if(km<=0 && callslist[jj].n_repeat==2) //    ,     callsloc.txt
         {                                      //       
           FILE *fp=fopen("known_list.txt","a+");
           fprintf(fp,"%s\n",op_call[i].callsign);
           fclose(fp);
         }
         if(km>0) //   callsloc,       
         {
          if(freqlist[op_call[i].n]==0) //    ,      
          {freqlist[op_call[i].n]=1;
           double ff=Fdial+F0 + op_call[i].n*(100.0/NF);
           FILE *fp=fopen("freq_list.txt","a+");
           fprintf(fp,"%.3f\t%s\n",ff,op_call[i].callsign);
           fclose(fp);
          }
         }
         break;
        }
      }
      if(!known_callsign) //     ,  
      {
        callslist[nc].call=op_call[i].callsign;
        callslist[nc].qth="";
        callslist[nc].km=-1;
        callslist[nc].n_repeat=1;
        callslist[nc].nf=op_call[i].n;
        callslist[nc].t=t; //    ,       
        char call[7]; memset(call,0,sizeof(call));
        strncpy(call,callslist[nc].call.c_str(),6);
        AnsiString pic=op_code(call,callslist[nc].v51);
        for(int i=0; i<239;i++)
        {if(pic.SubString(i+1,1)=="1")callslist[nc].pic[i]=1; else callslist[nc].pic[i]=-1; }
        nc++;if(nc>=N_OPCALL)nc=N_OPCALL-1;
      }
      if(!known_callsign) symbol='-';

       int fad=floor(100.0-op_call[i].correlation)/2.0;
       if(fad<0)fad=0;

      if(km>=0)kmstr.sprintf("%5d km\t",km);else kmstr="        \t";
      opstr.sprintf("%2.1fdB\t%+2.1fdB\t%d\t%d%%", op_call[i].db, op_call[i].db3+op_db_shift,op_call[i].attempt,fad);
      if(op_call[i].attempt==0) //        c
       opstr.sprintf("%2.1fdB\t%+2.1fdB\t%c\t%d%%",op_call[i].db, op_call[i].db3+op_db_shift,symbol,fad);
      if(op_call[i].attempt==-1) //  opds  d
       opstr.sprintf("%2.1fdB\t%+2.1fdB\t%c\t%d%%", op_call[i].db, op_call[i].db3+op_db_shift,symbol,fad);

      tstr=tstr+kmstr+opstr;
    if((UseKnownCallsList1->Checked && known_callsign ) || !UseKnownCallsList1->Checked )
    {
      Memo1->Lines->Insert(1,tstr);
      decoded=true;
       try{
        if(reverse_output)
        { FILE *fp=fopen(my_detected.c_str(),"a+");
          char tmp_name[13];
          do
          { sprintf(tmp_name,"tmp_%4d.txt",rand()%10000);
          }while(FileExists(tmp_name));
          FILE *fp_tmp=fopen(tmp_name,"w+");
         //      (3- )
          fseek(fp,0,0);
          int line=0; bool line_enough=false;
          while(!feof(fp))
          {int c=fgetc(fp);
           if(c!=EOF)fputc(c,fp_tmp);
           if(c=='\n')
           { line++;
             if(line==3){fprintf(fp_tmp,"%s\n",tstr.c_str());line_enough=true;}
           }
          }
          if(!line_enough)//    3      
          { //     
            fseek(fp_tmp,0,0);
            fprintf(fp_tmp,"%s\n\n",myheader.c_str());
            fprintf(fp_tmp,"   DATE     TIME     CALL    FREQ       QRB     Eb/No     SNR   DEC    FADE\n");
            fprintf(fp_tmp,"%s\n",tstr.c_str());
          }
         fclose(fp_tmp);
         fclose(fp);
         DeleteFile(my_detected);
         rename(tmp_name, my_detected.c_str());
        }
        else  // 
        {FILE *fp=fopen(my_detected.c_str(),"a+");
         fprintf(fp,"%s\n",tstr.c_str());
         fclose(fp);
        }
        if(CaptureSpectrum1->Checked)
        {AnsiString filename;
         filename.sprintf("%s_%04u%02u%02u_%02u%02u.jpg", op_call[i].callsign,t_cur->tm_year+1900,t_cur->tm_mon+1,t_cur->tm_mday,t_cur->tm_hour,t_cur->tm_min);
         filename=capturePath+filename;
         AnsiString fstr;
         fstr.sprintf("%04u-%02u-%02u %02u:%02u:%02u  %s de %s %+.1fdB at %.2fHz in %s ",t_cur->tm_year+1900,t_cur->tm_mon+1,t_cur->tm_mday,t_cur->tm_hour,t_cur->tm_min,t_cur->tm_sec,op_call[i].callsign,mycall,op_call[i].db3+op_db_shift,Fdial+F0 + op_call[i].n*(100.0/NF),myqth);
         capture(op_call[i].n,op_call[i].callsign,filename, fstr);
        }
          }catch(...){}

        //          
        int block_time=0.9*LEN_M_OP;
        if(op_call[i].n-3>=0)blockedlist[op_call[i].n-3]=block_time;
        if(op_call[i].n-2>=0)blockedlist[op_call[i].n-2]=block_time;
        if(op_call[i].n-1>=0)blockedlist[op_call[i].n-1]=block_time;
        blockedlist[op_call[i].n]=block_time;
        if(op_call[i].n+1<NF) blockedlist[op_call[i].n+1]=block_time;
        if(op_call[i].n+2<NF) blockedlist[op_call[i].n+2]=block_time;
        if(op_call[i].n+3<NF) blockedlist[op_call[i].n+3]=block_time;

        if(UploadSpot1->Checked &&(symbol==' ' || (uploadcorrelatoropdsspots1->Checked && (symbol=='c' || symbol=='d'))))
        {try{
          reporterSendReport(op_call[i].callsign," ",Fdial+F0 + op_call[i].n*(100.0/NF),op_call[i].db3+op_db_shift);
            }catch(...){}
        }
        if(UploadSpot1->Checked && UploadSpotstoOPERAcluster1->Checked)
        {
          if(symbol==' ' || (uploadcorrelatoropdsspots1->Checked && (symbol=='c' || symbol=='d')))
          {AnsiString rep;
           int fad=floor(100.0-op_call[i].correlation)/2.0;
           if(fad<0)fad=0;
           if(symbol=='c' || symbol=='d') fad=200; //  deep search
           if(km>=0)rep.sprintf("%d km F:%d%% %+.0f dB in %s (%d km)",km,fad,op_call[i].db3+op_db_shift,myqth,km);
           else rep.sprintf("F:%d%% %+.0f dB in %s ",fad,op_call[i].db3+op_db_shift,myqth);
           Form3->sendOperaSpot(op_call[i].callsign, mycall, rep, qth, op_call[i].db3+op_db_shift,km,fad,Fdial+F0 + op_call[i].n*(100.0/NF));
          }
        }
      } // if known call
      op_call[i].callsign[0]=0;
      op_call[i].t=0;
      op_call[i].db=0; op_call[i].db2=0;
      op_call[i].n=0; op_call[i].cc=0;
      op_call[i].correlation=0;
      op_call[i].op=false;
    }  // if t
  } // for i
 ReleaseMutex(HMUT1);
 //  ,  
 if(decoded && commandExec)
 {//AnsiString runstr="start "+commandExecStr;
  AnsiString runstr=commandExecStr;
  WinExec(runstr.c_str(),SW_SHOWNA);
  //system(runstr.c_str());
 }
 
 if(snd->InOverflow) StatusBar1->Panels->Items[6]->Text="*";
 else StatusBar1->Panels->Items[6]->Text="";
 AnsiString sinp;
 if(Usred>0)sinp.sprintf("Volume %.1f dB",20*log10(Usred));
 StatusBar1->Panels->Items[3]->Text=sinp;
 Timer1->Enabled=true;

 if(Form3!=NULL)
 { if(OperaChatSpots1->Checked && !Form3->Visible)
  {Form3->Visible=true;
   Form3->Left=Form1->Left+Form1->Width+5;
   Form3->Top=Form1->Top;
  }
  if(Form3->CheckBox2->Checked != UploadSpotstoOPERAcluster1->Checked)
   Form3->CheckBox2->Checked=UploadSpotstoOPERAcluster1->Checked;
 }
}
//---------------------------------------------------------------------------



void __fastcall TForm1::Image3MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
     OscillN=NF * X/Image3->Width;
     AnsiString s;
     s.sprintf("%.2f Hz", Fdial+F0 + OscillN*(100.0/NF));
     StatusBar1->Panels->Items[2]->Text=s;
     if(OscillMode==0)
     {Image1->Canvas->Brush->Color= clBlack;
      Image1->Canvas->Pen->Color= clBlack;
      Image1->Canvas->FillRect(Rect(0,0,Image1->Width,Image1->Height));
      Image1->Canvas->MoveTo(0, Image1->Height-1);
     }
     OscillMode=1; cnt_qrss_mode=-1;
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Image1DblClick(TObject *Sender)
{
  OscillMode=0;        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Image2MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
     OscillN=NF * X/Image2->Width;
     AnsiString s;
     s.sprintf("%.2f Hz", Fdial+F0 + OscillN*(100.0/NF));
     StatusBar1->Panels->Items[2]->Text=s;
     if(OscillMode==0)
     {Image1->Canvas->Brush->Color= clBlack;
      Image1->Canvas->Pen->Color= clBlack;
      Image1->Canvas->FillRect(Rect(0,0,Image1->Width,Image1->Height));
      Image1->Canvas->MoveTo(0, Image1->Height-1);
     }
     OscillMode=1;
     cnt_qrss_mode=-1;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Oscillogramm1Click(TObject *Sender)
{
 if(Oscillogramm1->Checked)Oscillogramm1->Checked=false;
 else Oscillogramm1->Checked=true;

 Image1->Visible=Oscillogramm1->Checked;
 if(Image1->Visible==false)
 { if(Image2->Visible) {Image2->Top=0;Image3->Top=42;}
   else {Image3->Top=0;}
 }
 else
 {
  if(Image2->Visible){Image2->Top=42;Image3->Top=84;}
  else{Image3->Top=42;}
  Image1->Top=0;
 }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Spectrum1Click(TObject *Sender)
{
  if(Spectrum1->Checked)Spectrum1->Checked=false;
  else Spectrum1->Checked=true;
  Image2->Visible=Spectrum1->Checked;

  if(Image2->Visible==false)
  { if(Image1->Visible) {Image1->Top=0;Image3->Top=42;}
    else {Image3->Top=0;}
  }
  else
  {
  if(Image1->Visible){Image2->Top=42;Image3->Top=84;}
  else{Image3->Top=42;}
  Image1->Top=0;
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Waterfall1Click(TObject *Sender)
{
 if(Waterfall1->Checked)Waterfall1->Checked=false;
 else Waterfall1->Checked=true;
 Image3->Visible=Waterfall1->Checked;
}
//---------------------------------------------------------------------------


void TForm1::capture(int n, AnsiString call, AnsiString filename, AnsiString str)
{
 if(processWav) return; //not for offline decoding
 TPoint CurPos=Image3->Canvas->PenPos;
 TColor col=Image3->Canvas->Brush->Color;
 TFontStyles curstyle=Image3->Canvas->Font->Style;
 Image3->Canvas->Font->Style=TFontStyles()<< fsBold;
 int x=n*Image3->Width / NF;
 int tw=Image3->Canvas->TextWidth(call);
 int th=Image3->Canvas->TextHeight(call);

 Image3->Canvas->Brush->Color=clWhite;// clRed;
 Image3->Canvas->Pen->Color=clWhite; //clRed;
 Image3->Canvas->MoveTo(x,th+2+10+YYY);
 Image3->Canvas->LineTo(x,th+3+YYY);

 Image3->Canvas->Font->Color=clWhite;//clBlack;
 Image3->Canvas->Brush->Color=clBlack;//clWhite;// clBlack;
 Image3->Canvas->Pen->Color=clWhite; //clBlack;
 Image3->Canvas->Brush->Style = bsClear;
 Image3->Canvas->TextOut(x-tw/2,2+YYY,call);
 Image3->Canvas->Brush->Style = bsSolid;
 Image3->Canvas->Font->Style=curstyle;
 
 Image3->Canvas->Font->Color=clBlack;
 Image3->Canvas->Brush->Color= clWhite;
 Image3->Canvas->Pen->Color= clWhite;
 Image3->Canvas->TextOut(2,Image3->Height-th-1,str);
 
 Image3->Canvas->MoveTo(CurPos.x,CurPos.y);
 TJPEGImage *jp = new TJPEGImage();
 bool saved=false;
  try
  {
    jp->CompressionQuality=80;
    jp->Smoothing=false;
    jp->ProgressiveEncoding=true;
    jp->Assign(Image3->Picture->Bitmap);
    jp->Compress();
    jp->SaveToFile(filename);
    if(CaptureFilename.Pos(".bmp")>0) Image3->Picture->SaveToFile(CaptureFilename);
    else jp->SaveToFile(CaptureFilename);
    saved=true;
  }
  __finally
  {
    delete jp;
  }
  if(!saved)
  {Image3->Picture->SaveToFile(filename);
   Image3->Picture->SaveToFile(CaptureFilename); //  ,  
  }
 Image3->Canvas->Brush->Color= col;
 Image3->Canvas->Pen->Color= col;
}
//------------------------------------------------------------------------------
void __fastcall TForm1::default1Click(TObject *Sender)
{
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("SOUND","DEVICE",-1);
 delete ini;
 snd->closeIn(); snd->closeOut();
 snd->IN_DEVICE=-1;
 snd->openIn(SND_FD,16,1,SND_LEN);
 snd->openOut(SND_FD,16,1,SND_LEN);
 default1->Checked=true;
 StatusBar1->Panels->Items[4]->Text=default1->Caption;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::device01Click(TObject *Sender)
{
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("SOUND","DEVICE",0);
 delete ini;
 snd->closeIn(); snd->closeOut();
 snd->IN_DEVICE=0;
 snd->openIn(SND_FD,16,1,SND_LEN);
 snd->openOut(SND_FD,16,1,SND_LEN);
 device01->Checked=true;
 StatusBar1->Panels->Items[4]->Text=device01->Caption;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::device11Click(TObject *Sender)
{
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("SOUND","DEVICE",1);
 delete ini;
 snd->closeIn(); snd->closeOut();
 snd->IN_DEVICE=1;
 snd->openIn(SND_FD,16,1,SND_LEN);
 snd->openOut(SND_FD,16,1,SND_LEN);
 device11->Checked=true;
 StatusBar1->Panels->Items[4]->Text=device11->Caption;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::device21Click(TObject *Sender)
{
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("SOUND","DEVICE",2);
 delete ini;
 snd->closeIn(); snd->closeOut();
 snd->IN_DEVICE=2;
 snd->openIn(SND_FD,16,1,SND_LEN);
 snd->openOut(SND_FD,16,1,SND_LEN);
 device21->Checked=true;
 StatusBar1->Panels->Items[4]->Text=device21->Caption;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::device31Click(TObject *Sender)
{
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("SOUND","DEVICE",3);
 delete ini;
 snd->closeIn(); snd->closeOut();
 snd->IN_DEVICE=3;
 snd->openIn(SND_FD,16,1,SND_LEN);
 snd->openOut(SND_FD,16,1,SND_LEN);
 device31->Checked=true;
 StatusBar1->Panels->Items[4]->Text=device31->Caption;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::device41Click(TObject *Sender)
{
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("SOUND","DEVICE",4);
 delete ini;
 snd->closeIn(); snd->closeOut();
 snd->IN_DEVICE=4;
 snd->openIn(SND_FD,16,1,SND_LEN);
 snd->openOut(SND_FD,16,1,SND_LEN);
 device41->Checked=true;
 StatusBar1->Panels->Items[4]->Text=device41->Caption;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::device51Click(TObject *Sender)
{
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("SOUND","DEVICE",5);
 delete ini;
 snd->closeIn(); snd->closeOut();
 snd->IN_DEVICE=5;
 snd->openIn(SND_FD,16,1,SND_LEN);
 snd->openOut(SND_FD,16,1,SND_LEN);
 device51->Checked=true;
 StatusBar1->Panels->Items[4]->Text=device51->Caption;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::device61Click(TObject *Sender)
{
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("SOUND","DEVICE",6);
 delete ini;
 snd->closeIn(); snd->closeOut();
 snd->IN_DEVICE=6;
 snd->openIn(SND_FD,16,1,SND_LEN);
 snd->openOut(SND_FD,16,1,SND_LEN);
 device61->Checked=true;
 StatusBar1->Panels->Items[4]->Text=device61->Caption;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::device71Click(TObject *Sender)
{
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("SOUND","DEVICE",7);
 delete ini;
 snd->closeIn(); snd->closeOut();
 snd->IN_DEVICE=7;
 snd->openIn(SND_FD,16,1,SND_LEN);
 snd->openOut(SND_FD,16,1,SND_LEN);
 device71->Checked=true;
 StatusBar1->Panels->Items[4]->Text=device71->Caption;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::device81Click(TObject *Sender)
{
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("SOUND","DEVICE",8);
 delete ini;
 snd->closeIn(); snd->closeOut();
 snd->IN_DEVICE=8;
 snd->openIn(SND_FD,16,1,SND_LEN);
 snd->openOut(SND_FD,16,1,SND_LEN);
 device81->Checked=true;
 StatusBar1->Panels->Items[4]->Text=device81->Caption;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CaptureSpectrum1Click(TObject *Sender)
{
 if(CaptureSpectrum1->Checked)CaptureSpectrum1->Checked=false;
 else CaptureSpectrum1->Checked=true;        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::IgnoreLoran1Click(TObject *Sender)
{
 if(IgnoreLoran1->Checked)IgnoreLoran1->Checked=false;
 else IgnoreLoran1->Checked=true;        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::UploadSpot1Click(TObject *Sender)
{
 if(UploadSpot1->Checked){UploadSpot1->Checked=false;uploadcorrelatoropdsspots1->Enabled=false;UploadSpotstoOPERAcluster1->Enabled=false; Form3->CheckBox2->Enabled=false;}
 else {UploadSpot1->Checked=true;uploadcorrelatoropdsspots1->Enabled=true;UploadSpotstoOPERAcluster1->Enabled=true;Form3->CheckBox2->Enabled=true;}
 if(UploadSpot1->Checked) StatusBar1->Panels->Items[7]->Text="UPLOAD";
 else StatusBar1->Panels->Items[7]->Text="";
 if(UploadSpot1->Checked)
 {int r;
  r=ReporterInitialize(Rep.hostname,Rep.port);
  if(r!=0)
  {wchar_t buf[256];
   ReporterGetInformation(buf,256);
   AnsiString s="PSKReporter Init Error:\n"+AnsiString(buf);
   MessageBox(NULL,s.c_str(),"PSKReporter Initialization",MB_OK|MB_ICONWARNING);
  }
  else ReporterGetStatistics(&Rep,sizeof(Rep));
 }
 else ReporterUninitialize();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N101Click(TObject *Sender)
{
 N101->Checked=true;
 maxNmax=10;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","N_MAX",maxNmax);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N201Click(TObject *Sender)
{
 N201->Checked=true;
 maxNmax=20;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","N_MAX",maxNmax);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N301Click(TObject *Sender)
{
 N301->Checked=true;
 maxNmax=30;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","N_MAX",maxNmax);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N401Click(TObject *Sender)
{
 N401->Checked=true;
 maxNmax=40;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","N_MAX",maxNmax);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N501Click(TObject *Sender)
{
 N501->Checked=true;
 maxNmax=50;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","N_MAX",maxNmax);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N601Click(TObject *Sender)
{
 N601->Checked=true;
 maxNmax=60;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","N_MAX",maxNmax);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N701Click(TObject *Sender)
{
 N701->Checked=true;
 maxNmax=70;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","N_MAX",maxNmax);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N801Click(TObject *Sender)
{
 N801->Checked=true;
 maxNmax=80;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","N_MAX",maxNmax);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N901Click(TObject *Sender)
{
 N901->Checked=true;
 maxNmax=90;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","N_MAX",maxNmax);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N1001Click(TObject *Sender)
{
 N1001->Checked=true;
 maxNmax=100;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","N_MAX",maxNmax);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
 if(AUDIO_RX_WORKED){SuspendThread(hAudioRx);TerminateThread(hAudioRx,0);}
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","N_MAX",maxNmax);
 ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
 ini->WriteFloat("OP-32","PEAK_THRESHOLD",umax_threshold);
 ini->WriteBool("OP-32","CAPTURE_ENABLE",CaptureSpectrum1->Checked);
 ini->WriteBool("PSKREPORTER","UPLOAD_SPOT",UploadSpot1->Checked);
 ini->WriteBool("PSKREPORTER","UPLOAD_OPDS_SPOT",uploadcorrelatoropdsspots1->Checked);
 ini->WriteBool("OP-32","IGNORE_LORAN_LINES",IgnoreLoran1->Checked);
 ini->WriteBool("OP-32","USE_FREQUENCY_LIST",UseFreqList1->Checked);
 ini->WriteBool("OP-32","DEEP_DECODER",DeepDecoder1->Checked);
 ini->WriteBool("OP-32","ULTRA_DEEP_DECODER",UltraDeepDecoder1->Checked);
 ini->WriteBool("OP-32","USE_KNOWN_CALLSLIST",UseKnownCallsList1->Checked);
 ini->WriteBool("OP-32","USE_COHERENT_DETECTOR",CoherentDetector1->Checked);
 ini->WriteBool("OP-32","USE_CORRELATOR",CorrelationOPDS1->Checked);
 ini->WriteBool("OP-32","USE_OPDS",UseSoftCorrelatorOPDS1->Checked);
 ini->WriteBool("OP-32","DECODER_DRIFT_TRACKING",decoderDrift);
  ini->WriteBool("OP-32","DECODER_SR_COMPENSATION",decoderTshift);
  ini->WriteBool("OP-32","OSCILLOGRAM_VISIBLE",Oscillogramm1->Checked);
  ini->WriteBool("OP-32","SPECTRUM_VISIBLE",Spectrum1->Checked);
  ini->WriteInteger("OP-32","WATERFALL_CONTRAST",waterfalContrast);
 ini->WriteInteger("OP-32","OSCILL_MODE",oscillogrammMode);
 ini->WriteInteger("OP-32","OSCILL_N",OscillN);
 ini->WriteBool("OPERA_CHAT","VISIBLE",OperaChatSpots1->Checked);
 ini->WriteBool("OPERA_CHAT","ACTIVE",Form3->CheckBox1->Checked);
 ini->WriteBool("OPERA_CHAT","UPLOAD_SPOT",UploadSpotstoOPERAcluster1->Checked);
 delete ini;
 delete filter1;
 delete filter2;
 delete wf;
 delete snd;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N01Click(TObject *Sender)
{
 N01->Checked=true;
 minpkspace=0;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N11Click(TObject *Sender)
{
 N11->Checked=true;
 minpkspace=1;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N21Click(TObject *Sender)
{
 N21->Checked=true;
 minpkspace=2;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N31Click(TObject *Sender)
{
 N31->Checked=true;
 minpkspace=3;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N41Click(TObject *Sender)
{
 N41->Checked=true;
 minpkspace=4;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N51Click(TObject *Sender)
{
 N51->Checked=true;
 minpkspace=5;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N61Click(TObject *Sender)
{
 N61->Checked=true;
 minpkspace=6;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N71Click(TObject *Sender)
{
 N71->Checked=true;
 minpkspace=7;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N81Click(TObject *Sender)
{
 N81->Checked=true;
 minpkspace=8;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N91Click(TObject *Sender)
{
 N91->Checked=true;
 minpkspace=9;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N102Click(TObject *Sender)
{
 N102->Checked=true;
 minpkspace=10;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::user1Click(TObject *Sender)
{
 user1->Checked=true;
 minpkspace=user_minpkspace;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::user2Click(TObject *Sender)
{
  user2->Checked=true;
  maxNmax=user_maxNmax;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::UseFreqList1Click(TObject *Sender)
{
 if(UseFreqList1->Checked)UseFreqList1->Checked=false;
 else UseFreqList1->Checked=true;        
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool TForm1::reporterSendReport(AnsiString CALLSIGN, AnsiString QTH, float Freq, float db)
{
 if(!UploadSpot1->Checked) return false;
 if(processWav) return false;
 
 ReporterGetStatistics(&Rep,sizeof(Rep));
 if(!Rep.connected) ReporterInitialize(Rep.hostname,Rep.port);
 static char remote[1024], local[1024];
 AnsiString loc,rem;
 AnsiString myant;
 myant.sprintf("RX %+.1fdB on %.1fHz", db, Freq);
 AnsiString F="136000";
 AnsiString M="OPERA";
 AnsiString Prg="Op32Rx v1.8.4";
 if(CorrelationOPDS1->Checked) Prg=Prg+"+crrl";
 if(UseSoftCorrelatorOPDS1->Checked)Prg=Prg+"+opds";
 AnsiString snr; snr.sprintf("%+.1f dB",db);

 loc="STATION_CALLSIGN\t"+mycall+"\tMY_GRIDSQUARE\t"+myqth+"\t"+"PROGRAMID\t"+Prg+"\tMY_ANTENNA\t"+myant+"\t\t";
 int len=loc.Length();
 strcpy(local,loc.c_str());
 for(int i=0; i<len; i++){if(local[i]=='\t') local[i]=0;}
 
 rem="CALL\t"+CALLSIGN+"\t"+"MODE\t"+M+"\tFREQ\t"+F+"\tRST_SENT\t"+snr+"\t\t";
 len=rem.Length();
 strcpy(remote,rem.c_str());
 for(int i=0; i<len; i++){if(remote[i]=='\t') remote[i]=0;}
 if(ReporterSeenCallsignSTD(remote,local,REPORTER_SOURCE_AUTOMATIC)==0)
 {
  StatusBar1->Panels->Items[7]->Text="UPLOAD";
 }
 else { StatusBar1->Panels->Items[7]->Text="no upload";
        wchar_t buf[256];
         ReporterGetInformation(buf,256);
         AnsiString s="PSKReporter: "+AnsiString(buf);
        return false;
      }
 return true;
}
//---------------------------------------------------------------------------

//----------------------------------------------------------------------------
void __fastcall TForm1::auto1Click(TObject *Sender)
{
 auto1->Checked=true; maxNmax=-1;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","N_MAX",maxNmax);
 delete ini;     
}
//---------------------------------------------------------------------------

void __fastcall TForm1::AddthisfrequencytoIgnoreList1Click(TObject *Sender)
{
 float ff=Fdial+F0 + OscillN*(100.0/NF);
 FILE *fp=fopen("loran_lines.txt","a+");
 if(fp) fprintf(fp,"\n%.3f",ff);
 fclose(fp);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Alwaysdecodethisfrequency1Click(TObject *Sender)
{
  float ff=Fdial+F0 + OscillN*(100.0/NF);
  FILE *fp=fopen("freq_list.txt","a+");
  if(fp) fprintf(fp,"\n%.3f",ff);
  fclose(fp);
}
//---------------------------------------------------------------------------


void __fastcall TForm1::DecodeWAVfile1Click(TObject *Sender)
{
 OpenDialog1->FileName="";
 OpenDialog1->Execute();
 AnsiString wavefile=OpenDialog1->FileName;
 if(wavefile=="")return;
 wf->open(wavefile,"r");
 int sps=SND_FD;
 if(F0>=5450) sps=SND_FD2;
 if(wf->Format.nSamplesPerSec!=sps || wf->Format.wBitsPerSample!=16)
 {
  AnsiString s="WAV-file must be "+AnsiString(sps)+" sps, 16 bit!";
  MessageBox(NULL,s.c_str(),"WAV error",MB_OK|MB_ICONWARNING);
  processWav=false;
  return;
 }
 Memo1->Lines->Insert(1,"Processing file "+ExtractFileName(wavefile));
 processWav=true;
 snd->closeIn();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DeepDecoder1Click(TObject *Sender)
{
 if(DeepDecoder1->Checked)DeepDecoder1->Checked=false;
 else DeepDecoder1->Checked=true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::UseKnownCallsList1Click(TObject *Sender)
{
 if(UseKnownCallsList1->Checked)UseKnownCallsList1->Checked=false;
 else UseKnownCallsList1->Checked=true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::UltraDeepDecoder1Click(TObject *Sender)
{
 if(UltraDeepDecoder1->Checked)UltraDeepDecoder1->Checked=false;
 else {UltraDeepDecoder1->Checked=true; DeepDecoder1->Checked=true;}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Exit1Click(TObject *Sender)
{
 exit(0);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::About1Click(TObject *Sender)
{
 MessageBox(NULL,"Opera-32 open source RX programm.\nImplement soft decoder with options of deep (list) decoding\nand various central rx frequency from 500Hz to 23kHz.\n\nRN3AUS/Alex September 2016","About Op32Rx",MB_OK|MB_ICONINFORMATION);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Helpeng1Click(TObject *Sender)
{
 AnsiString s;
 s="Capture Spectrum: save screenshot of waterfall with decoded signal\n";
 s=s+"Ignore Loran Lines: don't decode signal on freqs from file loran_lines.txt\n";
 s=s+"Use Freq List: always decode signal on freqs from file freq_list.txt\n";
 s=s+"Use Known Calls List: decode is true if callsign match with call from file callsloc.txt\nor this callsign was decoded twice (first decode saved in file known_list.txt)\n";
 s=s+"Deep Decoder: use list decoding with short list\n";
 s=s+"Ultra Deep Decoder: use list decoding with long list\n";
 s=s+"Use binary PIC-Correlator: try to search matching binary quantisied detector output with PIC-code vector (239 bits) of each known callsign\n";
 s=s+" + Use Soft Correlator (OPDS): OPDS :)\n";
 s=s+"Frequency Drift Tracking (Decoder): decoder will try to decode drifting signal, but with increasing CPU load.\n";
 s=s+"Sample Rate Offset Compensator (Decoder): recomended option.\n";
 s=s+"Coherent Detector: use coherent (quadrature) or uncoherent amplitude detector\n";
 s=s+"Peak Number: number of spectral peaks for autofocus\n";
 s=s+"Peak Spacing: space between spectral peaks\n";
 s=s+"Upload Spots: upload spots to PSK-Reporter\n";
 s=s+" + Upload Correlator/OPDS Spots: upload this additional spots to PSK-Reporter\n";
 s=s+" + Upload Spots to OPERA cluster: upload spots to OPERA cluster :)\n";
 s=s+"Decode WAV-file: decode signals from wav-file (12 ksps, 16 bps).\n";
 MessageBox(NULL,s.c_str(),"Op32Rx Help",MB_OK|MB_ICONINFORMATION);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Helprus1Click(TObject *Sender)
{
 AnsiString s;
 s="Capture Spectrum:       .\n";
 s=s+"Ignore Loran Lines:        loran_lines.txt\n";
 s=s+"Use Freq List:        freq_list.txt\n";
 s=s+"Use Known Calls List:    ,      callsloc.txt  known_list.txt\n known_list.txt     .\n";
 s=s+"Deep Decoder:      .\n";
 s=s+"Ultra Deep Decoder:      .\n";
 s=s+"Use binary PIC-Correlator:           PIC-  .\n";
 s=s+" + Use Soft Correlator (OPDS): OPDS :)     .\n";
 s=s+"Frequency Drift Tracking (Decoder):        ;    CPU.\n";
 s=s+"Sample Rate Offset Compensator (Decoder):    ,   .\n";
 s=s+"Coherent Detector:   ()    \n";
 s=s+"Peak Number:     (    ).\n";
 s=s+"Peak Spacing:     .\n";
 s=s+"Upload Spots:     PSK-Reporter.\n";
 s=s+" + Upload Correlator/OPDS Spots:     (,       )!\n";
 s=s+" + Upload Spots to OPERA cluster:     Opera,       :)\n";
 s=s+"Decode WAV-file:    ( 12 , 16 ).\n";
 MessageBox(NULL,s.c_str(),"Op32Rx Help",MB_OK|MB_ICONINFORMATION);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SelectAll1Click(TObject *Sender)
{
 Memo1->SelectAll();        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Copy1Click(TObject *Sender)
{
 Memo1->CopyToClipboard();        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Erase1Click(TObject *Sender)
{
 Memo1->Clear();
 //Memo1->Lines->Add("   DATE     TIME     CALL    FREQ       QRB     Eb/No   SNR");
 Memo1->Lines->Add("   DATE     TIME     CALL    FREQ       QRB     Eb/No     SNR   DEC    FADE");
}
//---------------------------------------------------------------------------


void __fastcall TForm1::CoherentDetector1Click(TObject *Sender)
{
 if(CoherentDetector1->Checked) CoherentDetector1->Checked=false;
 else CoherentDetector1->Checked=true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CorrelationOPDS1Click(TObject *Sender)
{
 if(CorrelationOPDS1->Checked)
 { CorrelationOPDS1->Checked=false;UseSoftCorrelatorOPDS1->Enabled=false;}
 else {CorrelationOPDS1->Checked=true;UseSoftCorrelatorOPDS1->Enabled=true;}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Setupanothersettings1Click(TObject *Sender)
{
 
  Form2->Edit1->Text=mycall;
  Form2->Edit2->Text=myqth;
  Form2->ComboBox1->Text=AnsiString(Fdial);
  Form2->ComboBox2->Text=AnsiString(F0+50.0);
  Form2->Edit3->Text=my_detected;
  Form2->Edit4->Text=capturePath;
  Form2->Edit11->Text=CaptureFilename;
  Form2->UpDown1->Position=op_threshold;
  Form2->Edit5->Text=AnsiString(op_threshold);
  Form2->UpDown2->Position=op_db_shift;
  Form2->Edit6->Text=AnsiString(op_db_shift);
  Form2->UpDown3->Position=correlator_threshold;
  Form2->Edit7->Text=AnsiString(max1max2);
  Form2->UpDown5->Position=correlator_threshold239;
  Form2->Edit9->Text=AnsiString(correlator_threshold239);
  Form2->UpDown4->Position=opds_threshold;
  Form2->Edit8->Text=AnsiString(opds_threshold);
  Form2->UpDown6->Position=T_CALL_BLOCK;
  Form2->Edit10->Text=AnsiString(T_CALL_BLOCK);
  Form2->Edit12->Text=commandExecStr;
  Form2->CheckBox1->Checked=commandExec;

  TIniFile *ini;
  ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
  Form2->Edit13->Text= ini->ReadString("OP-32","MYCITY", "");
  Form2->Edit14->Text= ini->ReadString("OP-32","MYNAME", "");
  Form2->Edit15->Text= ini->ReadString("OP-32","MYANT", "");
  delete ini;
  Form2->Visible=true;
}
//---------------------------------------------------------------------------


bool TForm1::read_ini_file(bool restart)
{
  if(restart && AUDIO_RX_WORKED){SuspendThread(hAudioRx);AUDIO_RX_WORKED=false; if(restart)TerminateThread(hAudioRx,0);}
  TIniFile *ini;
  ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
  F0=(ini->ReadFloat("OP-32" ,"F_CENTER",1500.0)) - 50.0;
  if(F0<350.0) F0=350.0; if(F0>23000.0) F0=23000.0;
  ini->WriteFloat("OP-32" ,"F_CENTER",F0+50.0);
  if(F0<5450) snd->openIn(SND_FD,16,1,SND_LEN);
  else snd->openIn(SND_FD2,16,1,SND_LEN2);
  snd->openOut(SND_FD,16,1,SND_LEN);
  if(F0<5450) {dph=TWOPI*(F0-100.0)/SND_FD; dph2=0;}
  else {dph=TWOPI*(1500.0-100.0)/SND_FD; dph2=TWOPI*(F0-1500.0)/SND_FD2;}
  Fdial=ini->ReadFloat("OP-32" ,"F_DIAL",136000.0);
  maxNmax=ini->ReadInteger("OP-32","N_MAX",-1);
  if(maxNmax<-1)maxNmax=-1; if(maxNmax>NF)maxNmax=NF;
  minpkspace=ini->ReadInteger("OP-32","MIN_PEAK_SPACE",3);
  if(minpkspace<0)minpkspace=0; if(minpkspace>NF/2)minpkspace=NF/2;
  ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
  mycall=ini->ReadString("OP-32","MYCALL", "");
  Form3->mycall=mycall;
  myqth=ini->ReadString("OP-32","MYQTH", "");
  Form3->myqth=myqth;
  my_detected=ini->ReadString("OP-32","FILE", "my_detected.txt");
  CaptureFilename=ini->ReadString("OP-32","CAPTURE_FILENAME", "op32rx_capture.jpg");
  ini->WriteString("OP-32","CAPTURE_FILENAME", CaptureFilename);
  capturePath=ini->ReadString("OP-32","CAPTURE_PATH", "Capture\\");
  capturePath=IncludeTrailingBackslash(capturePath);
  if (!DirectoryExists(capturePath))
  {
    if (!CreateDir(capturePath))
      throw Exception("Cannot create "+capturePath+" directory.");
  }
  commandExec=ini->ReadBool("OP-32","EXECUTE_IF_DECODED_ENABLE",false);
  commandExecStr=ini->ReadString("OP-32","EXECUTE_IF_DECODED", "");
  op_db_shift=ini->ReadFloat("OP-32","OPERA_DB_OFFSET",-10.0);
  op_threshold=ini->ReadFloat("OP-32","OP_THRESHOLD",4.0);
  correlator_threshold239=ini->ReadInteger("OP-32","CORRELATOR_237_THRESHOLD",162);
  opds_threshold=ini->ReadFloat("OP-32","OPDS_THRESHOLD",2.0);
  max1max2=ini->ReadFloat("OP-32","OPDS_MAX1MAX2_THRESHOLD",1.78);
  T_CALL_BLOCK=ini->ReadInteger("OP-32","TIME_CALL_BLOCKED",600);
  myheader=ini->ReadString("OP-32","MYHEADER", "");
  if(myheader=="")myheader.sprintf("%s %s Opera-32 decoded (Op32Rx RN3AUS software)",mycall, myqth);
 delete ini;

   //// loading call and locations
  {
  FILE * fp=fopen("callsloc.txt","r");
  if(fp!=NULL)
  {nc=0;
   char in[40];
   char qth[7];
   char call[7];
   double mylat=0, mylon=0, lon=0, lat=0, km=-1;
   qth2latlon(myqth,mylon,mylat);
   while(feof(fp)==0 && nc<N_OPCALL)
   {
     memset(in,0,sizeof(in)); memset(qth,0,sizeof(qth));
    try{
     memset(in,0,sizeof(in)); memset(qth,0,sizeof(qth));   memset(call,0,sizeof(call));
     fgets(in,40,fp);
     if(!isalpha(in[0]) && !isdigit(in[0])) continue;
     callslist[nc].call=AnsiString(strtok(in," \n\r\t"));
     strncpy(call,callslist[nc].call.c_str(),6);
     callslist[nc].call=AnsiString(call);
     strncpy(qth,strtok(NULL," \n\r\t"),6);
     qth2latlon(qth,lon,lat);
     callslist[nc].km=calcdist(lon,lat,mylon,mylat);
     callslist[nc].qth=AnsiString(qth);
     AnsiString pic=op_code(call,callslist[nc].v51);
     for(int i=0; i<239;i++)
     {if(pic.SubString(i+1,1)=="1")callslist[nc].pic[i]=1; else callslist[nc].pic[i]=-1; }
     nc++; if(nc>=N_OPCALL){nc=N_OPCALL-1; break;}
      } catch(...){break;}
    }
  }
  fclose(fp);
  }
  ////// end loading callsloc

 //// loading call from knowncall
  {
  FILE * fp=fopen("known_list.txt","r");
  if(fp!=NULL)
  {char in[40];
   char call[7];
   while(feof(fp)==0 && nc<N_OPCALL)
   {
    try{
     memset(in,0,sizeof(in)); memset(call,0,sizeof(call));
     fgets(in,40,fp);
     if(!isalpha(in[0]) && !isdigit(in[0])) continue;
     callslist[nc].call=AnsiString(strtok(in," \n\r\t"));
     strncpy(call,callslist[nc].call.c_str(),6);
     callslist[nc].km=-1;
     callslist[nc].qth="";
     AnsiString pic=op_code(call,callslist[nc].v51);
     for(int i=0; i<239;i++)
     {if(pic.SubString(i+1,1)=="1")callslist[nc].pic[i]=1; else callslist[nc].pic[i]=-1; }
     nc++; if(nc>=N_OPCALL){nc=N_OPCALL-1; break;}
      } catch(...){break;}
    }
  }
  fclose(fp);
  }
  ////// end loading callsloc

  StatusBar1->Panels->Items[0]->Text="Dial="+AnsiString(Fdial)+ "Hz";
  StatusBar1->Panels->Items[1]->Text="Fc="+AnsiString(F0+50.0)+ "Hz";
  if(restart)
  {DWORD RxThreadId;
   AUDIO_RX_WORKED=false;
   hAudioRx=CreateThread(NULL,0,AudioRxThread,0,CREATE_SUSPENDED,&RxThreadId);
   SetThreadPriority(hAudioRx, THREAD_PRIORITY_NORMAL);
  }
  if(!AUDIO_RX_WORKED){ResumeThread(hAudioRx);}
  return true;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Cleanupknowlist1Click(TObject *Sender)
{
  remove("known_list.txt");
  int nc_del=0;
  WaitForSingleObject(HMUT1,1000);
  for(int n=0; n<nc; n++)
  { if(callslist[n].km==-1)
    { callslist[n].call="";
      callslist[n].qth="";
      memset(callslist[n].pic,0,240*sizeof(int));
      memset(callslist[n].v51,0,52*sizeof(int));
      callslist[n].n_repeat=0;
      callslist[n].t=0;
      nc_del++;
    }
  }
  nc=nc-nc_del;
  ReleaseMutex(HMUT1);
  StatusBar1->Panels->Items[4]->Text=AnsiString(nc_del)+" items deleted";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::UseSoftCorrelatorOPDS1Click(TObject *Sender)
{
  if(UseSoftCorrelatorOPDS1->Checked) UseSoftCorrelatorOPDS1->Checked=false;
  else UseSoftCorrelatorOPDS1->Checked=true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::uploadcorrelatoropdsspots1Click(TObject *Sender)
{
 if(uploadcorrelatoropdsspots1->Checked) uploadcorrelatoropdsspots1->Checked=false;
 else uploadcorrelatoropdsspots1->Checked=true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FreqDriftDecoderTracking1Click(TObject *Sender)
{
 if(FreqDriftDecoderTracking1->Checked)FreqDriftDecoderTracking1->Checked=false;
 else FreqDriftDecoderTracking1->Checked=true;
 decoderDrift=FreqDriftDecoderTracking1->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SampleRateOffsetCompensateDecoder1Click(
      TObject *Sender)
{
 if(SampleRateOffsetCompensateDecoder1->Checked)SampleRateOffsetCompensateDecoder1->Checked=false;
 else SampleRateOffsetCompensateDecoder1->Checked=true;
 decoderTshift=SampleRateOffsetCompensateDecoder1->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Low1Click(TObject *Sender)
{
 Low1->Checked=true;
 waterfalContrast=0;
 cnt_qrss_mode=-1;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Medium1Click(TObject *Sender)
{
 Medium1->Checked=true;
 waterfalContrast=1;
 cnt_qrss_mode=-1;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::High1Click(TObject *Sender)
{
 High1->Checked=true;
 waterfalContrast=2;
 cnt_qrss_mode=-1;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N0dBnothreshold1Click(TObject *Sender)
{
 N0dBnothreshold1->Checked=true;
 umax_threshold=0;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteFloat("OP-32","PEAK_THRESHOLD",umax_threshold);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N02dB1Click(TObject *Sender)
{
 N02dB1->Checked=true;
 umax_threshold=0.2;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteFloat("OP-32","PEAK_THRESHOLD",umax_threshold);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N04dB1Click(TObject *Sender)
{
 N04dB1->Checked=true;
 umax_threshold=0.4;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteFloat("OP-32","PEAK_THRESHOLD",umax_threshold);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N08dB1Click(TObject *Sender)
{
 N08dB1->Checked=true;
 umax_threshold=0.6;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteFloat("OP-32","PEAK_THRESHOLD",umax_threshold);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N11dB1Click(TObject *Sender)
{
 N11dB1->Checked=true;
 umax_threshold=0.8;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteFloat("OP-32","PEAK_THRESHOLD",umax_threshold);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N15dB1Click(TObject *Sender)
{
 N15dB1->Checked=true;
 umax_threshold=1.0;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteFloat("OP-32","PEAK_THRESHOLD",umax_threshold);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N20dB1Click(TObject *Sender)
{
 N20dB1->Checked=true;
 umax_threshold=1.2;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteFloat("OP-32","PEAK_THRESHOLD",umax_threshold);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::N25dB1Click(TObject *Sender)
{
 N25dB1->Checked=true;
 umax_threshold=1.5;
 TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteFloat("OP-32","PEAK_THRESHOLD",umax_threshold);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::userdB1Click(TObject *Sender)
{
 userdB1->Checked=true;
 AnsiString s=userdB1->Caption;
 if(s.SubString(1,1)=="&") s=s.Delete(1,1);
 try{umax_threshold=s.ToDouble();}catch(...){}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FilterDetectorChannelOutput1Click(TObject *Sender)
{
 FilterDetectorChannelOutput1->Checked=true;
 oscillogrammMode=1;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::QRSSViewer1Click(TObject *Sender)
{
 QRSSViewer1->Checked=true;
 oscillogrammMode=2;
 cnt_qrss_mode=-1;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Oscillogramm2Click(TObject *Sender)
{
  Oscillogramm2->Checked=true;
  oscillogrammMode=0;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::StatusBar1Hint(TObject *Sender)
{
 StatusBar1->Hint=StatusBar1->Panels->Items[4]->Text;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::StatusBar1Click(TObject *Sender)
{
 StatusBar1->ShowHint=true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SaveSettingstoinifile1Click(TObject *Sender)
{
  TIniFile *ini;
 ini = new TIniFile(ChangeFileExt( Application->ExeName, ".INI" ));
 ini->WriteInteger("OP-32","N_MAX",maxNmax);
 ini->WriteInteger("OP-32","MIN_PEAK_SPACE",minpkspace);
 ini->WriteFloat("OP-32","PEAK_THRESHOLD",umax_threshold);
 ini->WriteBool("OP-32","CAPTURE_ENABLE",CaptureSpectrum1->Checked);
 ini->WriteBool("PSKREPORTER","UPLOAD_SPOT",UploadSpot1->Checked);
 ini->WriteBool("PSKREPORTER","UPLOAD_OPDS_SPOT",uploadcorrelatoropdsspots1->Checked);
 ini->WriteBool("OP-32","IGNORE_LORAN_LINES",IgnoreLoran1->Checked);
 ini->WriteBool("OP-32","USE_FREQUENCY_LIST",UseFreqList1->Checked);
 ini->WriteBool("OP-32","DEEP_DECODER",DeepDecoder1->Checked);
 ini->WriteBool("OP-32","ULTRA_DEEP_DECODER",UltraDeepDecoder1->Checked);
 ini->WriteBool("OP-32","USE_KNOWN_CALLSLIST",UseKnownCallsList1->Checked);
 ini->WriteBool("OP-32","USE_COHERENT_DETECTOR",CoherentDetector1->Checked);
 ini->WriteBool("OP-32","USE_CORRELATOR",CorrelationOPDS1->Checked);
 ini->WriteBool("OP-32","USE_OPDS",UseSoftCorrelatorOPDS1->Checked);
 ini->WriteBool("OP-32","DECODER_DRIFT_TRACKING",decoderDrift);
  ini->WriteBool("OP-32","DECODER_SR_COMPENSATION",decoderTshift);
  ini->WriteBool("OP-32","OSCILLOGRAM_VISIBLE",Oscillogramm1->Checked);
  ini->WriteBool("OP-32","SPECTRUM_VISIBLE",Spectrum1->Checked);
  ini->WriteInteger("OP-32","WATERFALL_CONTRAST",waterfalContrast);
 ini->WriteInteger("OP-32","OSCILL_MODE",oscillogrammMode);
 ini->WriteInteger("OP-32","OSCILL_N",OscillN);
 ini->WriteBool("OPERA_CHAT","VISIBLE",OperaChatSpots1->Checked);
 ini->WriteBool("OPERA_CHAT","ACTIVE",Form3->CheckBox1->Checked);
 ini->WriteBool("OPERA_CHAT","UPLOAD_SPOT",UploadSpotstoOPERAcluster1->Checked);
 delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::OperaChatSpots1Click(TObject *Sender)
{
 if(OperaChatSpots1->Checked) OperaChatSpots1->Checked=false;
 else OperaChatSpots1->Checked=true;
 Form3->Visible= OperaChatSpots1->Checked;
 if(Form3->Visible)Form3->WindowState=wsNormal;
 Form3->Left=Form1->Left+Form1->Width+5;
 Form3->Top=Form1->Top;

}
//---------------------------------------------------------------------------

void __fastcall TForm1::UploadSpotstoOPERAcluster1Click(TObject *Sender)
{
 if(UploadSpotstoOPERAcluster1->Checked)UploadSpotstoOPERAcluster1->Checked=false;
 else UploadSpotstoOPERAcluster1->Checked=true;

 if(UploadSpotstoOPERAcluster1->Checked)
 { OperaChatSpots1->Checked=true;
   Form3->Visible= OperaChatSpots1->Checked;
   Form3->WindowState=wsNormal;
   Form3->ClientSocket1->Open();
 }
 if(Form3->CheckBox2->Checked != UploadSpotstoOPERAcluster1->Checked)
   Form3->CheckBox2->Checked=UploadSpotstoOPERAcluster1->Checked;
}
//---------------------------------------------------------------------------



